/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.util.List;
import org.apache.syncope.common.lib.to.BpmnProcess;
import org.apache.syncope.common.lib.types.BpmnProcessFormat;
import org.apache.syncope.common.rest.api.service.BpmnProcessService;
import org.apache.syncope.core.logic.BpmnProcessLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;

public class BpmnProcessServiceImpl
extends AbstractService
implements BpmnProcessService {
    protected final BpmnProcessLogic logic;

    public BpmnProcessServiceImpl(BpmnProcessLogic logic) {
        this.logic = logic;
    }

    public List<BpmnProcess> list() {
        return this.logic.list();
    }

    public Response get(String key) {
        BpmnProcessFormat format = this.messageContext.getHttpHeaders().getAcceptableMediaTypes().contains(MediaType.APPLICATION_JSON_TYPE) ? BpmnProcessFormat.JSON : BpmnProcessFormat.XML;
        StreamingOutput sout = os -> this.logic.exportDefinition(key, format, os);
        return Response.ok((Object)sout).type(format.getMediaType()).build();
    }

    public Response exportDiagram(String key) {
        StreamingOutput sout = os -> this.logic.exportDiagram(key, os);
        return Response.ok((Object)sout).type("image/png").build();
    }

    public void set(String key, String definition) {
        BpmnProcessFormat format = this.messageContext.getHttpHeaders().getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE) ? BpmnProcessFormat.JSON : BpmnProcessFormat.XML;
        this.logic.importDefinition(key, format, definition);
    }

    public void delete(String key) {
        this.logic.delete(key);
    }
}

