/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.metadata;

import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.AttributeIndex;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.support.KeyStatisticsAttributeIndex;
import com.googlecode.cqengine.index.support.KeyStatisticsIndex;
import com.googlecode.cqengine.index.support.SortedKeyStatisticsAttributeIndex;
import com.googlecode.cqengine.index.support.SortedKeyStatisticsIndex;
import com.googlecode.cqengine.metadata.AttributeMetadata;
import com.googlecode.cqengine.metadata.SortedAttributeMetadata;
import com.googlecode.cqengine.query.option.QueryOptions;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class MetadataEngine<O> {
    private final IndexedCollection<O> indexedCollection;
    private final Supplier<QueryOptions> openResourcesHandler;
    private final Consumer<QueryOptions> closeResourcesHandler;

    public MetadataEngine(IndexedCollection<O> indexedCollection, Supplier<QueryOptions> openResourcesHandler, Consumer<QueryOptions> closeResourcesHandler) {
        this.indexedCollection = indexedCollection;
        this.openResourcesHandler = openResourcesHandler;
        this.closeResourcesHandler = closeResourcesHandler;
    }

    public <A> AttributeMetadata<A, O> getAttributeMetadata(Attribute<O, A> attribute) {
        KeyStatisticsIndex index = this.getIndexOnAttribute(KeyStatisticsAttributeIndex.class, attribute);
        return new AttributeMetadata(index, this.openResourcesHandler, this.closeResourcesHandler);
    }

    public <A extends Comparable<A>> SortedAttributeMetadata<A, O> getSortedAttributeMetadata(Attribute<O, A> attribute) {
        SortedKeyStatisticsIndex index = this.getIndexOnAttribute(SortedKeyStatisticsAttributeIndex.class, attribute);
        return new SortedAttributeMetadata(index, this.openResourcesHandler, this.closeResourcesHandler);
    }

    private <A, I extends AttributeIndex<A, O>> I getIndexOnAttribute(Class<I> indexType, Attribute<O, A> attribute) {
        for (Index index : this.indexedCollection.getIndexes()) {
            AttributeIndex attributeIndex;
            if (!indexType.isAssignableFrom(index.getClass()) || !(attributeIndex = (AttributeIndex)indexType.cast(index)).getAttribute().equals(attribute)) continue;
            return (I)attributeIndex;
        }
        throw new IllegalStateException("A " + indexType.getSimpleName() + " has not been added to the collection, and must be added first, to enable metadata to be examined for attribute: " + attribute);
    }
}

