/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.util;

import java.nio.charset.Charset;
import java.util.List;
import javax.naming.directory.BasicAttribute;
import net.tirasa.connid.bundles.ldap.schema.GuardedPasswordAttribute;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.OperationalAttributes;

public abstract class ADGuardedPasswordAttribute
extends GuardedPasswordAttribute {
    private static final Log LOG = Log.getLog(ADGuardedPasswordAttribute.class);

    public static ADGuardedPasswordAttribute create(String attrName, Attribute attr) {
        assert (attr.is(OperationalAttributes.PASSWORD_NAME));
        List value = attr.getValue();
        if (value != null && !value.isEmpty()) {
            return ADGuardedPasswordAttribute.create(attrName, (GuardedString)value.get(0));
        }
        return ADGuardedPasswordAttribute.create(attrName);
    }

    public static ADGuardedPasswordAttribute create(String attrName, GuardedString password) {
        return new Simple(attrName, password);
    }

    public static ADGuardedPasswordAttribute create(String attrName) {
        return new Empty(attrName);
    }

    private static final class Empty
    extends ADGuardedPasswordAttribute {
        private final String attrName;

        private Empty(String attrName) {
            this.attrName = attrName;
        }

        public void access(GuardedPasswordAttribute.Accessor accessor) {
            accessor.access((javax.naming.directory.Attribute)new BasicAttribute(this.attrName));
        }
    }

    private static final class Simple
    extends ADGuardedPasswordAttribute {
        private final String attrName;
        private final GuardedString password;

        private Simple(String attrName, GuardedString password) {
            this.attrName = attrName;
            this.password = password;
        }

        public void access(GuardedPasswordAttribute.Accessor accessor) {
            this.password.access(clearChars -> {
                String quotedPwd = "\"" + new String(clearChars) + "\"";
                byte[] unicodePwd = quotedPwd.getBytes(Charset.forName("UTF-16LE"));
                BasicAttribute attr = new BasicAttribute(this.attrName, unicodePwd);
                accessor.access((javax.naming.directory.Attribute)attr);
            });
        }
    }
}

