/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Writer;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedWriter;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class WireTapIn
extends AbstractPhaseInterceptor<Message> {
    private static final String WIRE_TAP_STARTED = WireTapIn.class.getName() + ".Started";
    private long threshold;
    private int limit;

    public WireTapIn(int limit, long threshold) {
        super("receive");
        this.limit = limit;
        this.threshold = threshold;
    }

    public void handleMessage(Message message) throws Fault {
        if (message.containsKey((Object)WIRE_TAP_STARTED)) {
            return;
        }
        message.put((Object)WIRE_TAP_STARTED, (Object)Boolean.TRUE);
        try {
            InputStream is = (InputStream)message.getContent(InputStream.class);
            if (is != null) {
                this.handleInputStream(message, is);
            } else {
                Reader reader = (Reader)message.getContent(Reader.class);
                if (reader != null) {
                    this.handleReader(message, reader);
                }
            }
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    private void handleReader(Message message, Reader reader) throws IOException {
        CachedWriter writer = new CachedWriter();
        IOUtils.copyAndCloseInput((Reader)reader, (Writer)writer);
        message.setContent(Reader.class, (Object)writer.getReader());
        message.setContent(CachedWriter.class, (Object)writer);
    }

    private void handleInputStream(Message message, InputStream is) throws IOException {
        CachedOutputStream bos = new CachedOutputStream();
        if (this.threshold > 0L) {
            bos.setThreshold(this.threshold);
        }
        InputStream bis = is instanceof DelegatingInputStream ? ((DelegatingInputStream)is).getInputStream() : is;
        IOUtils.copyAtLeast((InputStream)bis, (OutputStream)bos, (int)(this.limit == -1 ? Integer.MAX_VALUE : this.limit));
        bos.flush();
        bis = new SequenceInputStream(bos.getInputStream(), bis);
        if (is instanceof DelegatingInputStream) {
            ((DelegatingInputStream)is).setInputStream(bis);
        } else {
            message.setContent(InputStream.class, (Object)bis);
        }
        message.setContent(CachedOutputStream.class, (Object)bos);
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setThreshold(long threshold) {
        this.threshold = threshold;
    }
}

