/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.gen.RSAKeyGenerator;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.Map;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.OIDCJWKSTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.OIDCJWKS;
import org.apache.syncope.core.provisioning.api.data.OIDCJWKSDataBinder;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCJWKSDataBinderImpl
implements OIDCJWKSDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(OIDCJWKSDataBinder.class);
    protected final EntityFactory entityFactory;

    public OIDCJWKSDataBinderImpl(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    public OIDCJWKSTO getOIDCJWKSTO(OIDCJWKS jwks) {
        return new OIDCJWKSTO.Builder().json(jwks.getJson()).key(jwks.getKey()).build();
    }

    public OIDCJWKS create(String jwksKeyId, String jwksType, int jwksKeySize) {
        JWK jwk;
        try {
            block5 : switch (jwksType.trim().toLowerCase()) {
                case "ec": {
                    KeyPairGenerator gen = KeyPairGenerator.getInstance("EC");
                    switch (jwksKeySize) {
                        case 384: {
                            gen.initialize(Curve.P_384.toECParameterSpec());
                            KeyPair keyPair = gen.generateKeyPair();
                            jwk = new ECKey.Builder(Curve.P_384, (ECPublicKey)keyPair.getPublic()).privateKey((ECPrivateKey)keyPair.getPrivate()).keyUse(KeyUse.SIGNATURE).keyID(jwksKeyId.concat("-").concat(SecureRandomUtils.generateRandomUUID().toString().substring(0, 8))).build();
                            break block5;
                        }
                        case 512: {
                            gen.initialize(Curve.P_521.toECParameterSpec());
                            KeyPair keyPair = gen.generateKeyPair();
                            jwk = new ECKey.Builder(Curve.P_521, (ECPublicKey)keyPair.getPublic()).privateKey((ECPrivateKey)keyPair.getPrivate()).keyUse(KeyUse.SIGNATURE).keyID(jwksKeyId.concat("-").concat(SecureRandomUtils.generateRandomUUID().toString().substring(0, 8))).build();
                            break block5;
                        }
                    }
                    gen.initialize(Curve.P_256.toECParameterSpec());
                    KeyPair keyPair = gen.generateKeyPair();
                    jwk = new ECKey.Builder(Curve.P_256, (ECPublicKey)keyPair.getPublic()).privateKey((ECPrivateKey)keyPair.getPrivate()).keyUse(KeyUse.SIGNATURE).keyID(jwksKeyId.concat("-").concat(SecureRandomUtils.generateRandomUUID().toString().substring(0, 8))).build();
                    break;
                }
                default: {
                    jwk = new RSAKeyGenerator(jwksKeySize).keyUse(KeyUse.SIGNATURE).keyID(jwksKeyId.concat("-").concat(SecureRandomUtils.generateRandomUUID().toString().substring(0, 8))).generate();
                    break;
                }
            }
        }
        catch (JOSEException | InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            LOG.error("Could not create OIDC JWKS", e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Unknown);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        OIDCJWKS jwks = (OIDCJWKS)this.entityFactory.newEntity(OIDCJWKS.class);
        jwks.setJson(JSONObjectUtils.toJSONString((Map)new JWKSet(jwk).toJSONObject(false)));
        return jwks;
    }
}

