/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.support.saml.InMemoryResourceMetadataResolver;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.BaseSamlRegisteredServiceMetadataResolver;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.inspektr.audit.annotation.Audit;
import org.opensaml.core.xml.persist.FilesystemLoadSaveManager;
import org.opensaml.core.xml.persist.XMLObjectLoadSaveManager;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.DefaultLocalDynamicSourceKeyGenerator;
import org.opensaml.saml.metadata.resolver.impl.LocalDynamicMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class FileSystemResourceMetadataResolver
extends BaseSamlRegisteredServiceMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemResourceMetadataResolver.class);

    public FileSystemResourceMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        super(samlIdPProperties, configBean);
    }

    @Override
    @Audit(action="SAML2_METADATA_RESOLUTION", actionResolverName="SAML2_METADATA_RESOLUTION_ACTION_RESOLVER", resourceResolverName="SAML2_METADATA_RESOLUTION_RESOURCE_RESOLVER")
    public Collection<? extends MetadataResolver> resolve(SamlRegisteredService service, CriteriaSet criteriaSet) {
        ArrayList<AbstractMetadataResolver> listOfResolvers = new ArrayList<AbstractMetadataResolver>();
        try {
            Set metadataLocations = StringUtils.commaDelimitedListToSet((String)SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation()));
            for (String metadataLocation : metadataLocations) {
                if (!FileSystemResourceMetadataResolver.isMetadataFileSystemResource(metadataLocation)) continue;
                LOGGER.info("Loading SAML metadata from [{}]", (Object)metadataLocation);
                AbstractResource metadataResource = ResourceUtils.getResourceFrom((String)metadataLocation);
                File metadataFile = metadataResource.getFile();
                AbstractMetadataResolver metadataResolver = this.getMetadataResolver(metadataResource, metadataFile);
                this.configureAndInitializeSingleMetadataResolver(metadataResolver, service);
                listOfResolvers.add(metadataResolver);
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return listOfResolvers;
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        return (Boolean)FunctionUtils.doAndHandle(() -> {
            String metadataLocation = SpringExpressionLanguageValueResolver.getInstance().resolve(service.getMetadataLocation());
            Set metadataLocations = StringUtils.commaDelimitedListToSet((String)metadataLocation);
            return metadataLocations.stream().anyMatch(FileSystemResourceMetadataResolver::isMetadataFileSystemResource);
        }, throwable -> false).get();
    }

    private static boolean isMetadataFileSystemResource(String location) {
        AbstractResource metadataResource = (AbstractResource)FunctionUtils.doUnchecked(() -> ResourceUtils.isUrl((String)location) ? null : ResourceUtils.getResourceFrom((String)location));
        Optional scriptFactory = ExecutableCompiledScriptFactory.findExecutableCompiledScriptFactory();
        return metadataResource instanceof FileSystemResource && (scriptFactory.isEmpty() || !((ExecutableCompiledScriptFactory)scriptFactory.get()).isScript(location));
    }

    @Override
    public boolean isAvailable(SamlRegisteredService service) {
        return this.supports(service);
    }

    private AbstractMetadataResolver getMetadataResolver(AbstractResource metadataResource, File metadataFile) throws Exception {
        if (metadataFile.isDirectory()) {
            DefaultLocalDynamicSourceKeyGenerator sourceStrategy = new DefaultLocalDynamicSourceKeyGenerator("", ".xml", "");
            FilesystemLoadSaveManager manager = new FilesystemLoadSaveManager(metadataFile, this.configBean.getParserPool());
            return new LocalDynamicMetadataResolver((XMLObjectLoadSaveManager)manager, (Function)sourceStrategy);
        }
        return new InMemoryResourceMetadataResolver((Resource)metadataResource, this.configBean);
    }
}

