/*
 * Decompiled with CFR 0.152.
 */
package org.hjson;

import org.hjson.IHjsonDsfProvider;
import org.hjson.JsonNumber;
import org.hjson.JsonValue;

class DsfMath
implements IHjsonDsfProvider {
    DsfMath() {
    }

    @Override
    public String getName() {
        return "math";
    }

    @Override
    public String getDescription() {
        return "support for Inf/inf, -Inf/-inf, Nan/naN and -0";
    }

    @Override
    public JsonValue parse(String text) {
        switch (text) {
            case "+inf": 
            case "inf": 
            case "+Inf": 
            case "Inf": {
                return new JsonNumber(Double.POSITIVE_INFINITY);
            }
            case "-inf": 
            case "-Inf": {
                return new JsonNumber(Double.NEGATIVE_INFINITY);
            }
            case "nan": 
            case "NaN": {
                return new JsonNumber(Double.NaN);
            }
        }
        return null;
    }

    @Override
    public String stringify(JsonValue value) {
        if (!value.isNumber()) {
            return null;
        }
        double val = value.asDouble();
        if (val == Double.POSITIVE_INFINITY) {
            return "Inf";
        }
        if (val == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (Double.isNaN(val)) {
            return "NaN";
        }
        if (val == 0.0 && 1.0 / val == Double.NEGATIVE_INFINITY) {
            return "-0";
        }
        return null;
    }
}

