/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.introspection;

import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionAccessTokenResponse;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionResponseGenerator;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.ServiceAwareTicket;
import org.apereo.cas.util.CollectionUtils;

public class OAuth20DefaultIntrospectionResponseGenerator
implements OAuth20IntrospectionResponseGenerator {
    public OAuth20IntrospectionAccessTokenResponse generate(String accessTokenId, OAuth20Token accessToken) {
        OAuth20IntrospectionAccessTokenResponse introspect = new OAuth20IntrospectionAccessTokenResponse();
        introspect.setScope("CAS");
        introspect.setActive(accessToken != null && !accessToken.isExpired());
        if (introspect.isActive()) {
            return this.collectIntrospectionDetails(introspect, accessToken).setToken(accessTokenId);
        }
        return introspect;
    }

    protected OAuth20IntrospectionAccessTokenResponse collectIntrospectionDetails(OAuth20IntrospectionAccessTokenResponse introspect, OAuth20Token accessToken) {
        introspect.setClientId(accessToken.getClientId());
        if (accessToken instanceof ServiceAwareTicket) {
            ServiceAwareTicket sat = (ServiceAwareTicket)accessToken;
            introspect.setAud(sat.getService().getId());
        }
        Authentication authentication = accessToken.getAuthentication();
        LinkedHashMap attributes = new LinkedHashMap(authentication.getAttributes());
        attributes.putAll(authentication.getPrincipal().getAttributes());
        String subject = authentication.getPrincipal().getId();
        introspect.setSub(subject);
        introspect.setUniqueSecurityName(subject);
        introspect.setIat(accessToken.getCreationTime().toInstant().getEpochSecond());
        introspect.setExp(introspect.getIat() + accessToken.getExpirationPolicy().getTimeToLive());
        Object methods = attributes.get("authenticationMethod");
        String realmNames = CollectionUtils.toCollection(methods).stream().map(Object::toString).collect(Collectors.joining(","));
        introspect.setRealmName(realmNames);
        String tokenType = attributes.containsKey("DPoPConfirmation") ? "DPoP" : "Bearer";
        introspect.setTokenType(tokenType);
        CollectionUtils.firstElement(attributes.get("grant_type")).ifPresent(type -> introspect.setGrantType(type.toString()));
        CollectionUtils.firstElement(attributes.get("x509_digest")).ifPresent(digest -> introspect.getConfirmation().setX5t(digest.toString()));
        return introspect;
    }
}

