/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.clientapps;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.clientapps.ClientAppPropertiesDirectoryPanel;
import org.apache.syncope.client.console.clientapps.UsernameAttributeProviderModalPanelBuilder;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalDirectoryPanel;
import org.apache.syncope.client.console.rest.AuditRestClient;
import org.apache.syncope.client.console.rest.ClientAppRestClient;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public abstract class ClientAppDirectoryPanel<T extends ClientAppTO>
extends DirectoryPanel<T, T, DirectoryDataProvider<T>, ClientAppRestClient> {
    private static final long serialVersionUID = 4100100988730985059L;
    @SpringBean
    protected PolicyRestClient policyRestClient;
    @SpringBean
    protected ClientAppRestClient clientAppRestClient;
    @SpringBean
    protected RealmRestClient realmRestClient;
    @SpringBean
    protected AuditRestClient auditRestClient;
    protected final ClientAppType type;
    protected final BaseModal<T> propertiesModal;
    protected final BaseModal<Serializable> historyModal;

    public ClientAppDirectoryPanel(String id, ClientAppRestClient restClient, ClientAppType type, PageReference pageRef) {
        super(id, (RestClient)restClient, pageRef, true);
        this.type = type;
        this.modal.addSubmitButton();
        this.modal.size(Modal.Size.Large);
        this.setWindowClosedReloadCallback(this.modal, true);
        this.setFooterVisibility(true);
        this.propertiesModal = new BaseModal<T>("outer"){
            private static final long serialVersionUID = 389935548143327858L;

            protected void onConfigure() {
                super.onConfigure();
                this.setFooterVisible(false);
            }
        };
        this.propertiesModal.size(Modal.Size.Large);
        this.setWindowClosedReloadCallback(this.propertiesModal);
        this.addOuterObject(new Component[]{this.propertiesModal});
        this.disableCheckBoxes();
        this.historyModal = new BaseModal("outer");
        this.historyModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.historyModal});
    }

    protected List<IColumn<T, String>> getColumns() {
        ArrayList<IColumn<T, String>> columns = new ArrayList<IColumn<T, String>>();
        columns.add((IColumn<T, String>)new KeyPropertyColumn((IModel)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this), (Object)"name", "name"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("clientAppId", (Component)this), (Object)"clientAppId", "clientAppId"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("evaluationOrder", (Component)this), (Object)"evaluationOrder", "evaluationOrder"));
        this.addCustomColumnFields(columns);
        return columns;
    }

    protected void addCustomColumnFields(List<IColumn<T, String>> columns) {
    }

    public ActionsPanel<T> getActions(final IModel<T> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                ClientAppDirectoryPanel.this.send((IEventSink)ClientAppDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent(((ClientAppRestClient)ClientAppDirectoryPanel.this.restClient).read(ClientAppDirectoryPanel.this.type, ((ClientAppTO)model.getObject()).getKey()), target));
            }
        }, ActionLink.ActionType.EDIT, "CLIENTAPP_CREATE");
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                model.setObject(((ClientAppRestClient)ClientAppDirectoryPanel.this.restClient).read(ClientAppDirectoryPanel.this.type, ((ClientAppTO)model.getObject()).getKey()));
                ClientAppDirectoryPanel.this.modal.setContent(new UsernameAttributeProviderModalPanelBuilder<ClientAppTO>(ClientAppDirectoryPanel.this.type, (ClientAppTO)model.getObject(), ClientAppDirectoryPanel.this.modal, ClientAppDirectoryPanel.this.clientAppRestClient, ClientAppDirectoryPanel.this.pageRef).build(ClientAppDirectoryPanel.this.actualId, 1, AjaxWizard.Mode.EDIT));
                ClientAppDirectoryPanel.this.modal.header((IModel)new Model((Serializable)((Object)ClientAppDirectoryPanel.this.getString("usernameAttributeProviderConf.title", model))));
                ClientAppDirectoryPanel.this.modal.show(true);
                target.add(new Component[]{ClientAppDirectoryPanel.this.modal});
            }
        }, ActionLink.ActionType.COMPOSE, "CLIENTAPP_CREATE");
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                model.setObject(((ClientAppRestClient)ClientAppDirectoryPanel.this.restClient).read(ClientAppDirectoryPanel.this.type, ((ClientAppTO)model.getObject()).getKey()));
                target.add(new Component[]{ClientAppDirectoryPanel.this.propertiesModal.setContent((ModalPanel)new ModalDirectoryPanel(ClientAppDirectoryPanel.this.propertiesModal, new ClientAppPropertiesDirectoryPanel("panel", (ClientAppRestClient)ClientAppDirectoryPanel.this.restClient, ClientAppDirectoryPanel.this.propertiesModal, ClientAppDirectoryPanel.this.type, model, ClientAppDirectoryPanel.this.pageRef), ClientAppDirectoryPanel.this.pageRef))});
                ClientAppDirectoryPanel.this.propertiesModal.header((IModel)new Model((Serializable)((Object)ClientAppDirectoryPanel.this.getString("properties.title", model))));
                ClientAppDirectoryPanel.this.propertiesModal.show(true);
            }
        }, ActionLink.ActionType.TYPE_EXTENSIONS, "CLIENTAPP_CREATE");
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -5432034353017728756L;

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                model.setObject(((ClientAppRestClient)ClientAppDirectoryPanel.this.restClient).read(ClientAppDirectoryPanel.this.type, ((ClientAppTO)model.getObject()).getKey()));
                target.add(new Component[]{ClientAppDirectoryPanel.this.historyModal.setContent((ModalPanel)new AuditHistoryModal<T>(AuditElements.EventCategoryType.LOGIC, "ClientAppLogic", (ClientAppTO)model.getObject(), "CLIENTAPP_CREATE", ClientAppDirectoryPanel.this.auditRestClient){
                    private static final long serialVersionUID = -3712506022627033811L;

                    protected void restore(String json, AjaxRequestTarget target) {
                        try {
                            ClientAppTO updated = (ClientAppTO)MAPPER.readValue(json, ClientAppTO.class);
                            ((ClientAppRestClient)ClientAppDirectoryPanel.this.restClient).update(ClientAppDirectoryPanel.this.type, updated);
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                        }
                        catch (Exception e) {
                            LOG.error("While restoring ClientApp {}", (Object)((ClientAppTO)model.getObject()).getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)ClientAppDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                ClientAppDirectoryPanel.this.historyModal.header((IModel)new Model((Serializable)((Object)ClientAppDirectoryPanel.this.getString("auditHistory.title", (IModel)new Model((Serializable)((ClientAppTO)model.getObject()))))));
                ClientAppDirectoryPanel.this.historyModal.show(true);
            }
        }, ActionLink.ActionType.VIEW_AUDIT_HISTORY, String.format("%s,%s", "CLIENTAPP_READ", "AUDIT_LIST"));
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                ClientAppTO clone = (ClientAppTO)SerializationUtils.clone((Serializable)((ClientAppTO)model.getObject()));
                clone.setKey(null);
                clone.setClientAppId(null);
                ClientAppDirectoryPanel.this.send((IEventSink)ClientAppDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)clone, target));
            }
        }, ActionLink.ActionType.CLONE, "CLIENTAPP_CREATE");
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                ClientAppTO clientAppTO = (ClientAppTO)model.getObject();
                try {
                    ((ClientAppRestClient)ClientAppDirectoryPanel.this.restClient).delete(ClientAppDirectoryPanel.this.type, clientAppTO.getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)ClientAppDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{ClientAppDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting {}", (Object)clientAppTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BaseWebPage)ClientAppDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "CLIENTAPP_DELETE", true);
        return panel;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected ClientAppDataProvider dataProvider() {
        return new ClientAppDataProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "clientapp.paginator.rows";
    }

    protected class ClientAppDataProvider
    extends DirectoryDataProvider<T> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final SortableDataProviderComparator<T> comparator;

        ClientAppDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("name", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator((SortableDataProvider)this);
        }

        public Iterator<T> iterator(long first, long count) {
            List list = ((ClientAppRestClient)ClientAppDirectoryPanel.this.restClient).list(ClientAppDirectoryPanel.this.type);
            list.sort(this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((ClientAppRestClient)ClientAppDirectoryPanel.this.restClient).list(ClientAppDirectoryPanel.this.type).size();
        }

        public IModel<T> model(T object) {
            return new CompoundPropertyModel(object);
        }
    }
}

