/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.web.flow;

import com.yubico.core.RegistrationStorage;
import com.yubico.data.CredentialRegistration;
import com.yubico.internal.util.JacksonCodecs;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.device.MultifactorAuthenticationRegisteredDevice;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationDeviceProviderAction;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class WebAuthnMultifactorDeviceProviderAction
extends BaseCasWebflowAction
implements MultifactorAuthenticationDeviceProviderAction {
    private final RegistrationStorage webAuthnCredentialRepository;

    protected Event doExecute(RequestContext requestContext) {
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = authentication.getPrincipal();
        Collection registrations = this.webAuthnCredentialRepository.getRegistrationsByUsername(principal.getId());
        List accounts = registrations.stream().filter(Objects::nonNull).map(this::mapWebAuthnAccount).collect(Collectors.toList());
        WebUtils.putMultifactorAuthenticationRegisteredDevices((RequestContext)requestContext, accounts);
        return null;
    }

    protected MultifactorAuthenticationRegisteredDevice mapWebAuthnAccount(CredentialRegistration acct) {
        Map vendor = acct.getAttestationMetadata().getVendorProperties().orElseGet(Map::of);
        Map device = acct.getAttestationMetadata().getDeviceProperties().orElseGet(Map::of);
        return (MultifactorAuthenticationRegisteredDevice)FunctionUtils.doUnchecked(() -> MultifactorAuthenticationRegisteredDevice.builder().id(acct.getCredential().getCredentialId().getBase64Url()).name(acct.getCredentialNickname()).type((String)vendor.get("name")).model((String)device.get("displayName")).lastUsedDateTime(acct.getRegistrationTime().toString()).payload(JacksonCodecs.json().writerWithDefaultPrettyPrinter().writeValueAsString((Object)acct)).source("Web Authn").build());
    }

    @Generated
    public WebAuthnMultifactorDeviceProviderAction(RegistrationStorage webAuthnCredentialRepository) {
        this.webAuthnCredentialRepository = webAuthnCredentialRepository;
    }
}

