/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.el;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.ValueCoercionException;
import org.springframework.util.Assert;

class BindingValueExpression
extends ValueExpression {
    private ValueExpression targetExpression;
    private Class<?> expectedType;
    private ConversionService conversionService;
    private boolean template;

    public BindingValueExpression(ValueExpression targetExpression, Class<?> expectedType, ConversionService conversionService, boolean template) {
        Assert.notNull(expectedType, (String)"The expectedType Class is required");
        Assert.notNull((Object)conversionService, (String)"The ConversionService to perform type coersions is required");
        this.targetExpression = targetExpression;
        this.expectedType = expectedType;
        this.conversionService = conversionService;
        this.template = template;
    }

    public Class<?> getExpectedType() {
        return this.targetExpression.getExpectedType();
    }

    public Class<?> getType(ELContext context) throws NullPointerException, ELException {
        return this.targetExpression.getType(context);
    }

    public Object getValue(ELContext context) throws NullPointerException, ELException, ValueCoercionException {
        Object value = this.targetExpression.getValue(context);
        return this.convertValueIfNecessary(value, this.expectedType, context);
    }

    public boolean isReadOnly(ELContext context) throws NullPointerException, ELException {
        return this.targetExpression.isReadOnly(context);
    }

    public void setValue(ELContext context, Object value) throws NullPointerException, ELException, ValueCoercionException {
        value = this.convertValueIfNecessary(value, this.targetExpression.getType(context), context);
        this.targetExpression.setValue(context, value);
    }

    public String getExpressionString() {
        if (this.template) {
            return this.targetExpression.getExpressionString();
        }
        String rawExpressionString = this.targetExpression.getExpressionString();
        return rawExpressionString.substring("#{".length(), rawExpressionString.length() - 1);
    }

    public boolean isLiteralText() {
        return this.targetExpression.isLiteralText();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BindingValueExpression)) {
            return false;
        }
        BindingValueExpression exp = (BindingValueExpression)((Object)obj);
        return this.targetExpression.equals((Object)exp.targetExpression);
    }

    public int hashCode() {
        return this.targetExpression.hashCode();
    }

    private Object convertValueIfNecessary(Object value, Class<?> expectedType, Object context) throws ValueCoercionException {
        if (expectedType == null) {
            return value;
        }
        try {
            return this.conversionService.executeConversion(value, expectedType);
        }
        catch (ConversionException e) {
            throw new ValueCoercionException(context.getClass(), this.getExpressionString(), value, expectedType, e);
        }
    }
}

