/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.dynareg;

import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationResponse;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.web.SimpleUrlValidatorFactoryBean;
import org.apereo.cas.web.UrlValidator;
import org.jose4j.jwk.JsonWebKeySet;
import org.springframework.core.io.AbstractResource;

public final class OidcClientRegistrationUtils {
    public static OidcClientRegistrationResponse getClientRegistrationResponse(OidcRegisteredService registeredService, String serverPrefix) {
        OidcClientRegistrationResponse clientResponse = new OidcClientRegistrationResponse();
        clientResponse.setApplicationType(registeredService.getApplicationType());
        clientResponse.setClientId(registeredService.getClientId());
        clientResponse.setClientSecret(registeredService.getClientSecret());
        clientResponse.setSubjectType(registeredService.getSubjectType());
        clientResponse.setTokenEndpointAuthMethod(registeredService.getTokenEndpointAuthenticationMethod());
        clientResponse.setClientName(registeredService.getName());
        clientResponse.setRedirectUris(CollectionUtils.wrap((Object)registeredService.getServiceId()));
        clientResponse.setUserInfoSignedReponseAlg(registeredService.getUserInfoSigningAlg());
        clientResponse.setUserInfoEncryptedReponseAlg(registeredService.getUserInfoEncryptedResponseAlg());
        clientResponse.setUserInfoEncryptedReponseEncoding(registeredService.getUserInfoEncryptedResponseEncoding());
        clientResponse.setContacts(registeredService.getContacts().stream().map(c -> StringUtils.defaultString((String)c.getEmail(), (String)c.getName())).filter(StringUtils::isNotBlank).collect(Collectors.toList()));
        clientResponse.setGrantTypes(Arrays.stream(OAuth20GrantTypes.values()).map(type -> type.getType().toLowerCase()).collect(Collectors.toList()));
        clientResponse.setResponseTypes(Arrays.stream(OAuth20ResponseTypes.values()).map(type -> type.getType().toLowerCase()).collect(Collectors.toList()));
        UrlValidator validator = new SimpleUrlValidatorFactoryBean(false).getObject();
        String keystore = SpringExpressionLanguageValueResolver.getInstance().resolve(registeredService.getJwks());
        FunctionUtils.doUnchecked(param -> {
            if (Objects.requireNonNull(validator).isValid(keystore)) {
                clientResponse.setJwksUri(keystore);
            } else if (ResourceUtils.doesResourceExist((String)keystore)) {
                AbstractResource res = ResourceUtils.getResourceFrom((String)keystore);
                String json = IOUtils.toString((InputStream)res.getInputStream(), (Charset)StandardCharsets.UTF_8);
                clientResponse.setJwks(new JsonWebKeySet(json).toJson());
            } else if (StringUtils.isNotBlank((CharSequence)keystore)) {
                JsonWebKeySet jwks = new JsonWebKeySet(keystore);
                clientResponse.setJwks(jwks.toJson());
            }
            clientResponse.setLogo(registeredService.getLogo());
            clientResponse.setPolicyUri(registeredService.getInformationUrl());
            clientResponse.setTermsOfUseUri(registeredService.getPrivacyUrl());
            clientResponse.setRedirectUris(CollectionUtils.wrapList((Object[])new String[]{registeredService.getServiceId()}));
            String clientConfigUri = OidcClientRegistrationUtils.getClientConfigurationUri(registeredService, serverPrefix);
            clientResponse.setRegistrationClientUri(clientConfigUri);
        }, (Object[])new Object[0]);
        clientResponse.setClientSecretExpiresAt(registeredService.getClientSecretExpiration());
        FunctionUtils.doIfNotNull((Object)registeredService.getDynamicRegistrationDateTime(), dt -> clientResponse.setClientIdIssuedAt(dt.toEpochSecond()));
        return clientResponse;
    }

    public static String getClientConfigurationUri(OidcRegisteredService registeredService, String serverPrefix) throws URISyntaxException {
        return new URIBuilder(serverPrefix.concat("/oidc/clientConfig")).addParameter("client_id", registeredService.getClientId()).build().toString();
    }

    @Generated
    private OidcClientRegistrationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

