/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.config;

import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.acct.AccountProfileServiceTicketGeneratorAuthority;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.pm.PasswordResetUrlBuilder;
import org.apereo.cas.pm.PasswordValidationService;
import org.apereo.cas.pm.web.flow.PasswordManagementAccountProfileWebflowConfigurer;
import org.apereo.cas.pm.web.flow.PasswordManagementCaptchaWebflowConfigurer;
import org.apereo.cas.pm.web.flow.PasswordManagementSingleSignOnParticipationStrategy;
import org.apereo.cas.pm.web.flow.PasswordManagementWebflowConfigurer;
import org.apereo.cas.pm.web.flow.actions.AccountProfilePasswordChangeRequestAction;
import org.apereo.cas.pm.web.flow.actions.AccountProfilePreparePasswordManagementAction;
import org.apereo.cas.pm.web.flow.actions.AccountProfileUpdateSecurityQuestionsAction;
import org.apereo.cas.pm.web.flow.actions.AccountUnlockStatusAction;
import org.apereo.cas.pm.web.flow.actions.AccountUnlockStatusPrepareAction;
import org.apereo.cas.pm.web.flow.actions.HandlePasswordExpirationWarningMessagesAction;
import org.apereo.cas.pm.web.flow.actions.InitPasswordChangeAction;
import org.apereo.cas.pm.web.flow.actions.InitPasswordResetAction;
import org.apereo.cas.pm.web.flow.actions.PasswordChangeAction;
import org.apereo.cas.pm.web.flow.actions.SendPasswordResetInstructionsAction;
import org.apereo.cas.pm.web.flow.actions.ValidatePasswordResetTokenAction;
import org.apereo.cas.pm.web.flow.actions.VerifyPasswordResetRequestAction;
import org.apereo.cas.pm.web.flow.actions.VerifySecurityQuestionsAction;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ServiceTicketGeneratorAuthority;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.CaptchaActivationStrategy;
import org.apereo.cas.web.CaptchaValidator;
import org.apereo.cas.web.DefaultCaptchaActivationStrategy;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.InitializeCaptchaAction;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategyConfigurer;
import org.apereo.cas.web.flow.ValidateCaptchaAction;
import org.apereo.cas.web.flow.actions.StaticEventExecutionAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.mvc.servlet.FlowHandler;
import org.springframework.webflow.mvc.servlet.FlowHandlerAdapter;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@AutoConfiguration
public class PasswordManagementWebflowConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordManagementWebflowConfiguration.class);

    @Configuration(value="PasswordManagementAccountProfileConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.AccountManagement, enabledByDefault=false)
    public static class PasswordManagementAccountProfileConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountProfileServiceTicketGeneratorAuthority"})
        public ServiceTicketGeneratorAuthority accountProfileServiceTicketGeneratorAuthority(CasConfigurationProperties casProperties) {
            return new AccountProfileServiceTicketGeneratorAuthority(casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountProfileUpdateSecurityQuestionsAction"})
        public Action accountProfileUpdateSecurityQuestionsAction(CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
            return new AccountProfileUpdateSecurityQuestionsAction(passwordManagementService, casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountProfilePasswordChangeRequestAction"})
        public Action accountProfilePasswordChangeRequestAction(@Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="passwordResetUrlBuilder") PasswordResetUrlBuilder passwordResetUrlBuilder) {
            return new AccountProfilePasswordChangeRequestAction(ticketRegistry, passwordResetUrlBuilder);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"prepareAccountProfilePasswordMgmtAction"})
        public Action prepareAccountProfilePasswordMgmtAction(CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
            return new AccountProfilePreparePasswordManagementAction(passwordManagementService, casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementAccountProfileWebflowConfigurer"})
        @DependsOn(value={"accountProfileWebflowConfigurer"})
        public CasWebflowConfigurer passwordManagementAccountProfileWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="accountProfileFlowRegistry") FlowDefinitionRegistry accountProfileFlowRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return new PasswordManagementAccountProfileWebflowConfigurer(flowBuilderServices, accountProfileFlowRegistry, applicationContext, casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementAccountProfileWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer passwordManagementAccountProfileWebflowExecutionPlanConfigurer(@Qualifier(value="passwordManagementAccountProfileWebflowConfigurer") CasWebflowConfigurer passwordManagementAccountProfileWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(passwordManagementAccountProfileWebflowConfigurer);
        }
    }

    @Configuration(value="PasswordManagementCaptchaConfiguration", proxyBeanMethods=false)
    @ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.PasswordManagement, module="captcha")
    public static class PasswordManagementCaptchaConfiguration {
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.pm.google-recaptcha.enabled").isTrue();

        @ConditionalOnMissingBean(name={"passwordManagementCaptchaWebflowConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public CasWebflowConfigurer passwordManagementCaptchaWebflowConfigurer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return (CasWebflowConfigurer)BeanSupplier.of(CasWebflowConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                PasswordManagementCaptchaWebflowConfigurer configurer = new PasswordManagementCaptchaWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
                configurer.setOrder(casProperties.getAuthn().getPm().getWebflow().getOrder() + 1);
                return configurer;
            }).otherwiseProxy().get();
        }

        @ConditionalOnMissingBean(name={"passwordResetValidateCaptchaAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public Action passwordResetValidateCaptchaAction(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="passwordResetCaptchaActivationStrategy") CaptchaActivationStrategy passwordResetCaptchaActivationStrategy) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                GoogleRecaptchaProperties recaptcha = casProperties.getAuthn().getPm().getGoogleRecaptcha();
                return new ValidateCaptchaAction(CaptchaValidator.getInstance((GoogleRecaptchaProperties)recaptcha), passwordResetCaptchaActivationStrategy);
            }).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"passwordResetCaptchaActivationStrategy"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CaptchaActivationStrategy passwordResetCaptchaActivationStrategy(ConfigurableApplicationContext applicationContext, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return (CaptchaActivationStrategy)BeanSupplier.of(CaptchaActivationStrategy.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new DefaultCaptchaActivationStrategy(servicesManager)).otherwiseProxy().get();
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"passwordResetInitializeCaptchaAction"})
        public Action passwordResetInitializeCaptchaAction(ConfigurableApplicationContext applicationContext, @Qualifier(value="passwordResetCaptchaActivationStrategy") CaptchaActivationStrategy passwordResetCaptchaActivationStrategy, CasConfigurationProperties casProperties) {
            return (Action)BeanSupplier.of(Action.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                GoogleRecaptchaProperties recaptcha = casProperties.getAuthn().getPm().getGoogleRecaptcha();
                return new InitializeCaptchaAction(passwordResetCaptchaActivationStrategy, requestContext -> WebUtils.putRecaptchaPasswordManagementEnabled((RequestContext)requestContext, (GoogleRecaptchaProperties)recaptcha), recaptcha);
            }).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementCaptchaWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer passwordManagementCaptchaWebflowExecutionPlanConfigurer(ConfigurableApplicationContext applicationContext, @Qualifier(value="passwordManagementCaptchaWebflowConfigurer") CasWebflowConfigurer cfg) {
            return (CasWebflowExecutionPlanConfigurer)BeanSupplier.of(CasWebflowExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerWebflowConfigurer(cfg)).otherwiseProxy().get();
        }
    }

    @Configuration(value="PasswordManagementWebflowActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementWebflowActionsConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountUnlockStatusPrepareAction"})
        public Action accountUnlockStatusPrepareAction() {
            return new AccountUnlockStatusPrepareAction();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"accountUnlockStatusAction"})
        public Action accountUnlockStatusAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
            return new AccountUnlockStatusAction(passwordManagementService);
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"initPasswordChangeAction"})
        public Action initPasswordChangeAction(CasConfigurationProperties casProperties) {
            return new InitPasswordChangeAction(casProperties);
        }

        @ConditionalOnMissingBean(name={"initPasswordResetAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public Action initPasswordResetAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
            return new InitPasswordResetAction(passwordManagementService);
        }

        @ConditionalOnMissingBean(name={"passwordChangeAction"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public Action passwordChangeAction(@Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, @Qualifier(value="passwordValidationService") PasswordValidationService passwordValidationService) {
            return new PasswordChangeAction(passwordManagementService, passwordValidationService);
        }

        @ConditionalOnMissingBean(name={"sendPasswordResetInstructionsAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action sendPasswordResetInstructionsAction(CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultPrincipalResolver") PrincipalResolver defaultPrincipalResolver, @Qualifier(value="communicationsManager") CommunicationsManager communicationsManager, @Qualifier(value="defaultTicketFactory") TicketFactory ticketFactory, @Qualifier(value="passwordResetUrlBuilder") PasswordResetUrlBuilder passwordResetUrlBuilder) {
            return new SendPasswordResetInstructionsAction(casProperties, communicationsManager, passwordManagementService, ticketRegistry, ticketFactory, defaultPrincipalResolver, passwordResetUrlBuilder);
        }

        @ConditionalOnMissingBean(name={"verifyPasswordResetRequestAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action verifyPasswordResetRequestAction(CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
            return new VerifyPasswordResetRequestAction(casProperties, passwordManagementService, ticketRegistry);
        }

        @ConditionalOnMissingBean(name={"handlePasswordExpirationWarningMessagesAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action handlePasswordExpirationWarningMessagesAction() {
            return new HandlePasswordExpirationWarningMessagesAction();
        }

        @ConditionalOnMissingBean(name={"verifySecurityQuestionsAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action verifySecurityQuestionsAction(CasConfigurationProperties casProperties, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService) {
            if (!casProperties.getAuthn().getPm().getReset().isSecurityQuestionsEnabled()) {
                LOGGER.debug("Functionality to handle security questions for password management is not enabled");
                return new StaticEventExecutionAction("success");
            }
            return new VerifySecurityQuestionsAction(passwordManagementService);
        }

        @ConditionalOnMissingBean(name={"validatePasswordResetTokenAction"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public Action validatePasswordResetTokenAction(@Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="passwordChangeService") PasswordManagementService passwordManagementService, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
            return new ValidatePasswordResetTokenAction(passwordManagementService, ticketRegistry);
        }
    }

    @Configuration(value="PasswordManagementWebflowBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementWebflowBaseConfiguration {
        @ConditionalOnMissingBean(name={"passwordManagementWebflowConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasWebflowConfigurer passwordManagementWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            return new PasswordManagementWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer passwordManagementCasWebflowExecutionPlanConfigurer(@Qualifier(value="passwordManagementWebflowConfigurer") CasWebflowConfigurer passwordManagementWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(passwordManagementWebflowConfigurer);
        }
    }

    @Configuration(value="PasswordManagementWebflowAdapterConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementWebflowAdapterConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public HandlerAdapter passwordResetHandlerAdapter(@Qualifier(value="loginFlowExecutor") FlowExecutor loginFlowExecutor) {
            FlowHandlerAdapter handler = new FlowHandlerAdapter(){

                public boolean supports(Object handler) {
                    return super.supports(handler) && ((FlowHandler)handler).getFlowId().equals("pswdreset");
                }
            };
            handler.setFlowExecutor(loginFlowExecutor);
            return handler;
        }
    }

    @Configuration(value="PasswordManagementWebflowSingleSignOnConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class PasswordManagementWebflowSingleSignOnConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementSingleSignOnParticipationStrategy"})
        public SingleSignOnParticipationStrategy passwordManagementSingleSignOnParticipationStrategy(@Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new PasswordManagementSingleSignOnParticipationStrategy(servicesManager, ticketRegistrySupport, authenticationServiceSelectionPlan);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"passwordManagementSingleSignOnParticipationStrategyConfigurer"})
        public SingleSignOnParticipationStrategyConfigurer passwordManagementSingleSignOnParticipationStrategyConfigurer(@Qualifier(value="passwordManagementSingleSignOnParticipationStrategy") SingleSignOnParticipationStrategy passwordManagementSingleSignOnParticipationStrategy) {
            return chain -> chain.addStrategy(passwordManagementSingleSignOnParticipationStrategy);
        }
    }
}

