/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.services.directory.Directory;
import com.google.api.services.directory.model.Alias;
import com.google.api.services.directory.model.Group;
import com.google.api.services.directory.model.Member;
import com.google.api.services.directory.model.OrgUnit;
import com.google.api.services.directory.model.User;
import com.google.api.services.licensing.Licensing;
import com.google.api.services.licensing.model.LicenseAssignment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import net.tirasa.connid.bundles.googleapps.GoogleApiExecutor;
import net.tirasa.connid.bundles.googleapps.GoogleAppsConfiguration;
import net.tirasa.connid.bundles.googleapps.GoogleAppsDelete;
import net.tirasa.connid.bundles.googleapps.GoogleAppsUtil;
import net.tirasa.connid.bundles.googleapps.GroupHandler;
import net.tirasa.connid.bundles.googleapps.LicenseAssignmentsHandler;
import net.tirasa.connid.bundles.googleapps.MembersHandler;
import net.tirasa.connid.bundles.googleapps.OrgunitsHandler;
import net.tirasa.connid.bundles.googleapps.RequestResultHandler;
import net.tirasa.connid.bundles.googleapps.UserHandler;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.AttributeDeltaUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public class GoogleAppsUpdate {
    private static final Log LOG = Log.getLog(GoogleAppsUpdate.class);
    private final GoogleAppsConfiguration configuration;
    private final ObjectClass objectClass;
    private final Uid uid;

    public GoogleAppsUpdate(GoogleAppsConfiguration configuration, ObjectClass objectClass, Uid uid) {
        this.configuration = configuration;
        this.objectClass = objectClass;
        this.uid = uid;
    }

    private Uid updateUser(AttributesAccessor accessor) {
        Attribute groups;
        List aliases;
        Uid uidAfterUpdate = this.uid;
        Directory.Users.Patch patch = UserHandler.updateUser(this.configuration.getDirectory().users(), this.uid.getUidValue(), accessor, this.configuration.getCustomSchemasJSON());
        if (null != patch) {
            uidAfterUpdate = GoogleApiExecutor.execute(patch, new RequestResultHandler<Directory.Users.Patch, User, Uid>(){

                @Override
                public Uid handleResult(Directory.Users.Patch request, User value) {
                    LOG.ok("User is Updated:{0}", new Object[]{value.getId()});
                    return new Uid(value.getId(), value.getEtag());
                }
            });
        }
        if (null != (aliases = accessor.findList("aliases"))) {
            Directory.Users.Aliases service = this.configuration.getDirectory().users().aliases();
            Set<String> currentAliases = UserHandler.listAliases(service, uidAfterUpdate.getUidValue());
            if (aliases.isEmpty()) {
                for (String alias : currentAliases) {
                    GoogleApiExecutor.execute(UserHandler.deleteUserAlias(service, uidAfterUpdate.getUidValue(), alias), new RequestResultHandler<Directory.Users.Aliases.Delete, Void, Object>(){

                        @Override
                        public Object handleResult(Directory.Users.Aliases.Delete request, Void value) {
                            return null;
                        }

                        @Override
                        public Object handleNotFound(IOException e) {
                            return null;
                        }
                    });
                }
            } else {
                ArrayList<Directory.Users.Aliases.Insert> addAliases = new ArrayList<Directory.Users.Aliases.Insert>();
                SortedSet keepAliases = CollectionUtil.newCaseInsensitiveSet();
                for (Object e : aliases) {
                    if (currentAliases.contains(e.toString())) {
                        keepAliases.add((String)e);
                        continue;
                    }
                    addAliases.add(UserHandler.createUserAlias(service, uidAfterUpdate.getUidValue(), (String)e));
                }
                for (Directory.Users.Aliases.Insert insert : addAliases) {
                    GoogleApiExecutor.execute(insert, new RequestResultHandler<Directory.Users.Aliases.Insert, Alias, Object>(){

                        @Override
                        public Object handleResult(Directory.Users.Aliases.Insert insert, Alias value) {
                            return null;
                        }

                        @Override
                        public Object handleDuplicate(IOException e) {
                            return null;
                        }
                    });
                }
                if (currentAliases.removeAll(keepAliases)) {
                    for (Object object : currentAliases) {
                        GoogleApiExecutor.execute(UserHandler.deleteUserAlias(service, (String)object, uidAfterUpdate.getUidValue()), new RequestResultHandler<Directory.Users.Aliases.Delete, Void, Object>(){

                            @Override
                            public Object handleResult(Directory.Users.Aliases.Delete request, Void value) {
                                return null;
                            }

                            @Override
                            public Object handleNotFound(IOException e) {
                                return null;
                            }
                        });
                    }
                }
            }
        }
        if (null != (groups = accessor.find(PredefinedAttributes.GROUPS_NAME)) && null != groups.getValue()) {
            Directory.Members service = this.configuration.getDirectory().members();
            Set<String> currentGroups = GroupHandler.listGroups(this.configuration.getDirectory().groups(), uidAfterUpdate.getUidValue(), this.configuration.getDomain());
            if (groups.getValue().isEmpty()) {
                for (String groupKey : currentGroups) {
                    GoogleApiExecutor.execute(MembersHandler.delete(service, groupKey, uidAfterUpdate.getUidValue()), new RequestResultHandler<Directory.Members.Delete, Void, Object>(){

                        @Override
                        public Object handleResult(Directory.Members.Delete request, Void value) {
                            return null;
                        }

                        @Override
                        public Object handleNotFound(IOException e) {
                            return null;
                        }
                    });
                }
            } else {
                ArrayList<Directory.Members.Insert> addGroups = new ArrayList<Directory.Members.Insert>();
                SortedSet keepGroups = CollectionUtil.newCaseInsensitiveSet();
                for (Object member : groups.getValue()) {
                    if (member instanceof String) {
                        if (currentGroups.contains((String)member)) {
                            keepGroups.add((String)member);
                            continue;
                        }
                        String email = accessor.getName().getNameValue();
                        addGroups.add(MembersHandler.create(service, (String)member, email, null));
                        continue;
                    }
                    if (null == member) continue;
                    throw new InvalidAttributeValueException("Attribute '__GROUPS__' must be a String list");
                }
                for (Directory.Members.Insert insert : addGroups) {
                    GoogleApiExecutor.execute(insert, new RequestResultHandler<Directory.Members.Insert, Member, Object>(){

                        @Override
                        public Object handleResult(Directory.Members.Insert request, Member value) {
                            return null;
                        }

                        @Override
                        public Object handleDuplicate(IOException e) {
                            return null;
                        }
                    });
                }
                if (currentGroups.removeAll(keepGroups)) {
                    for (String groupKey : currentGroups) {
                        GoogleApiExecutor.execute(MembersHandler.delete(service, groupKey, uidAfterUpdate.getUidValue()), new RequestResultHandler<Directory.Members.Delete, Void, Object>(){

                            @Override
                            public Object handleResult(Directory.Members.Delete request, Void value) {
                                return null;
                            }

                            @Override
                            public Object handleNotFound(IOException e) {
                                return null;
                            }
                        });
                    }
                }
            }
        }
        if (this.configuration.getRemoveLicenseOnDisable() && accessor.hasAttribute(OperationalAttributes.ENABLE_NAME) && !accessor.findBoolean(OperationalAttributes.ENABLE_NAME).booleanValue() && StringUtil.isNotBlank((String)accessor.findString("primaryEmail"))) {
            for (String skuId : this.configuration.getSkuIds()) {
                try {
                    Licensing.LicenseAssignments.Get get = this.configuration.getLicensing().licenseAssignments().get(this.configuration.getProductId(), skuId, accessor.findString("primaryEmail"));
                    GoogleApiExecutor.execute(get, new RequestResultHandler<Licensing.LicenseAssignments.Get, LicenseAssignment, Boolean>(){

                        @Override
                        public Boolean handleResult(Licensing.LicenseAssignments.Get request, LicenseAssignment value) {
                            try {
                                new GoogleAppsDelete(GoogleAppsUpdate.this.configuration, GoogleAppsUtil.LICENSE_ASSIGNMENT, new Uid(GoogleAppsUtil.generateLicenseId(value.getProductId(), value.getSkuId(), value.getUserId()))).execute();
                            }
                            catch (Exception e) {
                                LOG.error((Throwable)e, "Failed to delete license for user {0}", new Object[]{value.getUserId()});
                                throw ConnectorException.wrap((Throwable)e);
                            }
                            return true;
                        }

                        @Override
                        public Boolean handleNotFound(IOException e) {
                            return true;
                        }
                    });
                }
                catch (IOException iOException) {
                    LOG.error((Throwable)iOException, "Unable to find license for {0}-{1}-{2}", new Object[]{this.configuration.getProductId(), skuId, accessor.findString("primaryEmail")});
                }
            }
        }
        return uidAfterUpdate;
    }

    private Uid updateGroup(AttributesAccessor accessor) {
        Uid uidAfterUpdate;
        block18: {
            Set<String> currentAliases;
            Directory.Groups.Aliases service;
            List aliases;
            block19: {
                Attribute members;
                uidAfterUpdate = this.uid;
                Directory.Groups.Patch patch = GroupHandler.update(this.configuration.getDirectory().groups(), this.uid.getUidValue(), accessor);
                if (null != patch) {
                    uidAfterUpdate = GoogleApiExecutor.execute(patch, new RequestResultHandler<Directory.Groups.Patch, Group, Uid>(){

                        @Override
                        public Uid handleResult(Directory.Groups.Patch request, Group value) {
                            LOG.ok("Group is Updated:{0}", new Object[]{value.getId()});
                            return new Uid(value.getId(), value.getEtag());
                        }
                    });
                }
                if (null != (members = accessor.find("__MEMBERS__")) && null != members.getValue()) {
                    Directory.Members service2 = this.configuration.getDirectory().members();
                    if (members.getValue().isEmpty()) {
                        for (Map<String, String> member : MembersHandler.listMembers(service2, uidAfterUpdate.getUidValue(), null)) {
                            GoogleApiExecutor.execute(MembersHandler.delete(service2, uidAfterUpdate.getUidValue(), member.get("email")), new RequestResultHandler<Directory.Members.Delete, Void, Object>(){

                                @Override
                                public Object handleResult(Directory.Members.Delete request, Void value) {
                                    return null;
                                }

                                @Override
                                public Object handleNotFound(IOException e) {
                                    return null;
                                }
                            });
                        }
                    } else {
                        List<Map<String, String>> activeMembership = MembersHandler.listMembers(service2, uidAfterUpdate.getUidValue(), null);
                        ArrayList<Directory.Members.Insert> addMembership = new ArrayList<Directory.Members.Insert>();
                        ArrayList patchMembership = new ArrayList();
                        for (Object e : members.getValue()) {
                            if (e instanceof Map) {
                                String string = (String)((Map)e).get("email");
                                if (null == string) continue;
                                String role = (String)((Map)e).get("role");
                                if (null == role) {
                                    role = "MEMBER";
                                }
                                boolean notMember = true;
                                for (Map<String, String> a : activeMembership) {
                                    if (!string.equalsIgnoreCase(a.get("email"))) continue;
                                    a.put("keep", null);
                                    if (!role.equalsIgnoreCase(a.get("role"))) {
                                        patchMembership.add(MembersHandler.update(service2, uidAfterUpdate.getUidValue(), string, role));
                                    }
                                    notMember = false;
                                    break;
                                }
                                if (!notMember) continue;
                                addMembership.add(MembersHandler.create(service2, uidAfterUpdate.getUidValue(), string, role));
                                continue;
                            }
                            if (null == e) continue;
                            throw new InvalidAttributeValueException("Attribute 'members' must be a Map list");
                        }
                        for (Directory.Members.Insert insert : addMembership) {
                            GoogleApiExecutor.execute(insert, new RequestResultHandler<Directory.Members.Insert, Member, Object>(){

                                @Override
                                public Object handleResult(Directory.Members.Insert request, Member value) {
                                    return null;
                                }

                                @Override
                                public Object handleDuplicate(IOException e) {
                                    return null;
                                }
                            });
                        }
                        Iterator iterator = patchMembership.iterator();
                        while (iterator.hasNext()) {
                            Directory.Members.Patch patch2 = (Directory.Members.Patch)iterator.next();
                            GoogleApiExecutor.execute(patch2, new RequestResultHandler<Directory.Members.Patch, Member, Object>(){

                                @Override
                                public Object handleResult(Directory.Members.Patch request, Member value) {
                                    return null;
                                }
                            });
                        }
                        for (Map<String, String> map : activeMembership) {
                            if (map.containsKey("keep")) continue;
                            GoogleApiExecutor.execute(MembersHandler.delete(service2, uidAfterUpdate.getUidValue(), map.get("email")), new RequestResultHandler<Directory.Members.Delete, Void, Object>(){

                                @Override
                                public Object handleResult(Directory.Members.Delete request, Void value) {
                                    return null;
                                }

                                @Override
                                public Object handleNotFound(IOException e) {
                                    return null;
                                }
                            });
                        }
                    }
                }
                if (null == (aliases = accessor.findList("aliases"))) break block18;
                service = this.configuration.getDirectory().groups().aliases();
                currentAliases = GroupHandler.listAliases(service, uidAfterUpdate.getUidValue());
                if (!aliases.isEmpty()) break block19;
                for (Object e : currentAliases) {
                    GoogleApiExecutor.execute(GroupHandler.deleteGroupAlias(service, uidAfterUpdate.getUidValue(), (String)e), new RequestResultHandler<Directory.Groups.Aliases.Delete, Void, Object>(){

                        @Override
                        public Object handleResult(Directory.Groups.Aliases.Delete request, Void value) {
                            return null;
                        }

                        @Override
                        public Object handleNotFound(IOException e) {
                            return null;
                        }
                    });
                }
                break block18;
            }
            ArrayList<Directory.Groups.Aliases.Insert> addAliases = new ArrayList<Directory.Groups.Aliases.Insert>();
            SortedSet sortedSet = CollectionUtil.newCaseInsensitiveSet();
            for (Object e : aliases) {
                if (currentAliases.contains(e.toString())) {
                    sortedSet.add((String)e);
                    continue;
                }
                addAliases.add(GroupHandler.createGroupAlias(service, uidAfterUpdate.getUidValue(), (String)e));
            }
            for (Directory.Groups.Aliases.Insert insert : addAliases) {
                GoogleApiExecutor.execute(insert, new RequestResultHandler<Directory.Groups.Aliases.Insert, Alias, Object>(){

                    @Override
                    public Object handleResult(Directory.Groups.Aliases.Insert insert, Alias value) {
                        return null;
                    }

                    @Override
                    public Object handleDuplicate(IOException e) {
                        return null;
                    }
                });
            }
            if (!currentAliases.removeAll(sortedSet)) break block18;
            for (String string : currentAliases) {
                GoogleApiExecutor.execute(GroupHandler.deleteGroupAlias(service, string, uidAfterUpdate.getUidValue()), new RequestResultHandler<Directory.Groups.Aliases.Delete, Void, Object>(){

                    @Override
                    public Object handleResult(Directory.Groups.Aliases.Delete request, Void v) {
                        return null;
                    }

                    @Override
                    public Object handleNotFound(IOException e) {
                        return null;
                    }
                });
            }
        }
        return uidAfterUpdate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Uid update(Set<Attribute> replaceAttributes) {
        AttributesAccessor accessor = new AttributesAccessor(replaceAttributes);
        Uid uidAfterUpdate = this.uid;
        if (ObjectClass.ACCOUNT.equals((Object)this.objectClass)) {
            return this.updateUser(accessor);
        }
        if (ObjectClass.GROUP.equals((Object)this.objectClass)) {
            return this.updateGroup(accessor);
        }
        if (GoogleAppsUtil.MEMBER.equals((Object)this.objectClass)) {
            String role = accessor.findString("role");
            if (!StringUtil.isNotBlank((String)role)) return uidAfterUpdate;
            String[] ids = this.uid.getUidValue().split("/");
            if (ids.length != 2) throw new UnknownUidException("Invalid ID format");
            Directory.Members.Patch patch = MembersHandler.update(this.configuration.getDirectory().members(), ids[0], ids[1], role).setFields("email,etag");
            return GoogleApiExecutor.execute(patch, new RequestResultHandler<Directory.Members.Patch, Member, Uid>(){

                @Override
                public Uid handleResult(Directory.Members.Patch request, Member value) {
                    LOG.ok("Member is updated:{0}/{1}", new Object[]{request.getGroupKey(), value.getEmail()});
                    return MembersHandler.generateUid(request.getGroupKey(), value);
                }
            });
        }
        if (GoogleAppsUtil.ORG_UNIT.equals((Object)this.objectClass)) {
            Directory.Orgunits.Patch patch = OrgunitsHandler.update(this.configuration.getDirectory().orgunits(), this.uid.getUidValue(), accessor);
            if (null == patch) return uidAfterUpdate;
            return GoogleApiExecutor.execute(patch, new RequestResultHandler<Directory.Orgunits.Patch, OrgUnit, Uid>(){

                @Override
                public Uid handleResult(Directory.Orgunits.Patch request, OrgUnit value) {
                    LOG.ok("OrgUnit is updated:{0}", new Object[]{value.getName()});
                    return OrgunitsHandler.generateUid(value);
                }
            });
        }
        if (!GoogleAppsUtil.LICENSE_ASSIGNMENT.equals((Object)this.objectClass)) throw new UnsupportedOperationException("Update of type " + this.objectClass.getObjectClassValue() + " is not supported");
        Licensing.LicenseAssignments.Patch patch = LicenseAssignmentsHandler.update(this.configuration.getLicensing().licenseAssignments(), this.uid.getUidValue(), accessor);
        if (null == patch) return uidAfterUpdate;
        return GoogleApiExecutor.execute(patch, new RequestResultHandler<Licensing.LicenseAssignments.Patch, LicenseAssignment, Uid>(){

            @Override
            public Uid handleResult(Licensing.LicenseAssignments.Patch request, LicenseAssignment value) {
                LOG.ok("LicenseAssignment is Updated:{0}/{1}/{2}", new Object[]{value.getProductId(), value.getSkuId(), value.getUserId()});
                return LicenseAssignmentsHandler.generateUid(value);
            }
        });
    }

    private void updateDeltaUser(Set<AttributeDelta> modifications) {
        Directory.Users.Update update = UserHandler.updateUser(this.configuration.getDirectory().users(), this.uid.getUidValue(), modifications, this.configuration.getCustomSchemasJSON());
        if (null != update) {
            GoogleApiExecutor.execute(update, new RequestResultHandler<Directory.Users.Update, User, Uid>(){

                @Override
                public Uid handleResult(Directory.Users.Update request, User value) {
                    LOG.ok("User is Updated:{0}", new Object[]{value.getId()});
                    return GoogleAppsUpdate.this.uid;
                }
            });
        }
        HashSet groupsToAdd = new HashSet();
        HashSet groupsToRemove = new HashSet();
        Optional.ofNullable(AttributeDeltaUtil.find((String)PredefinedAttributes.GROUPS_NAME, modifications)).ifPresent(groups -> {
            block7: {
                block6: {
                    if (!CollectionUtil.isEmpty((Collection)groups.getValuesToReplace())) break block6;
                    if (!CollectionUtil.isEmpty((Collection)groups.getValuesToAdd())) {
                        for (Object group : CollectionUtil.nullAsEmpty((List)groups.getValuesToAdd())) {
                            groupsToAdd.add(group.toString());
                        }
                    }
                    if (CollectionUtil.isEmpty((Collection)groups.getValuesToRemove())) break block7;
                    for (Object group : CollectionUtil.nullAsEmpty((List)groups.getValuesToRemove())) {
                        groupsToRemove.add(group.toString());
                    }
                    break block7;
                }
                for (String groupKey : GroupHandler.listGroups(this.configuration.getDirectory().groups(), this.uid.getUidValue(), this.configuration.getDomain())) {
                    groupsToRemove.add(groupKey);
                }
                if (!CollectionUtil.isEmpty((Collection)groups.getValuesToAdd())) {
                    for (String group : CollectionUtil.nullAsEmpty((List)groups.getValuesToReplace())) {
                        groupsToAdd.add(group.toString());
                    }
                }
            }
        });
        Directory.Members membersService = this.configuration.getDirectory().members();
        for (String groupKey : groupsToRemove) {
            GoogleApiExecutor.execute(MembersHandler.delete(membersService, groupKey, this.uid.getUidValue()), new RequestResultHandler<Directory.Members.Delete, Void, Object>(){

                @Override
                public Object handleResult(Directory.Members.Delete request, Void value) {
                    return null;
                }

                @Override
                public Object handleNotFound(IOException e) {
                    return null;
                }
            });
        }
        for (String groupKey : groupsToAdd) {
            GoogleApiExecutor.execute(MembersHandler.create(membersService, groupKey, this.uid, null), new RequestResultHandler<Directory.Members.Insert, Member, Object>(){

                @Override
                public Object handleResult(Directory.Members.Insert request, Member value) {
                    return null;
                }

                @Override
                public Object handleDuplicate(IOException e) {
                    return null;
                }
            });
        }
        Directory.Users.Aliases aliasService = this.configuration.getDirectory().users().aliases();
        HashSet aliasesToAdd = new HashSet();
        HashSet aliasesToRemove = new HashSet();
        Optional.ofNullable(AttributeDeltaUtil.find((String)"aliases", modifications)).ifPresent(aliases -> {
            block6: {
                block5: {
                    if (!CollectionUtil.isEmpty((Collection)aliases.getValuesToReplace())) break block5;
                    if (!CollectionUtil.isEmpty((Collection)aliases.getValuesToAdd())) {
                        for (Object alias : CollectionUtil.nullAsEmpty((List)aliases.getValuesToAdd())) {
                            aliasesToAdd.add(alias.toString());
                        }
                    }
                    if (CollectionUtil.isEmpty((Collection)aliases.getValuesToRemove())) break block6;
                    for (Object alias : CollectionUtil.nullAsEmpty((List)aliases.getValuesToRemove())) {
                        aliasesToRemove.add(alias.toString());
                    }
                    break block6;
                }
                aliasesToRemove.addAll(UserHandler.listAliases(aliasService, this.uid.getUidValue()));
                if (!CollectionUtil.isEmpty((Collection)aliases.getValuesToAdd())) {
                    for (Object group : CollectionUtil.nullAsEmpty((List)aliases.getValuesToReplace())) {
                        aliasesToAdd.add(group.toString());
                    }
                }
            }
        });
        for (String alias : aliasesToRemove) {
            GoogleApiExecutor.execute(UserHandler.deleteUserAlias(aliasService, alias, this.uid.getUidValue()), new RequestResultHandler<Directory.Users.Aliases.Delete, Void, Object>(){

                @Override
                public Object handleResult(Directory.Users.Aliases.Delete request, Void v) {
                    return null;
                }

                @Override
                public Object handleNotFound(IOException e) {
                    return null;
                }
            });
        }
        for (String alias : aliasesToAdd) {
            GoogleApiExecutor.execute(UserHandler.createUserAlias(aliasService, this.uid.getUidValue(), alias), new RequestResultHandler<Directory.Users.Aliases.Insert, Alias, Object>(){

                @Override
                public Object handleResult(Directory.Users.Aliases.Insert insert, Alias value) {
                    return null;
                }

                @Override
                public Object handleDuplicate(IOException e) {
                    return null;
                }
            });
        }
    }

    private void updateDeltaGroup(Set<AttributeDelta> modifications) {
        Directory.Groups.Update update = GroupHandler.update(this.configuration.getDirectory().groups(), this.uid.getUidValue(), modifications);
        if (null != update) {
            GoogleApiExecutor.execute(update, new RequestResultHandler<Directory.Groups.Update, Group, Uid>(){

                @Override
                public Uid handleResult(Directory.Groups.Update request, Group value) {
                    LOG.ok("Group is Updated:{0}", new Object[]{value.getId()});
                    return GoogleAppsUpdate.this.uid;
                }
            });
        }
        Directory.Members membersService = this.configuration.getDirectory().members();
        HashSet membersToAdd = new HashSet();
        HashSet membersToRemove = new HashSet();
        Optional.ofNullable(AttributeDeltaUtil.find((String)"__MEMBERS__", modifications)).ifPresent(members -> {
            block7: {
                block6: {
                    if (!CollectionUtil.isEmpty((Collection)members.getValuesToReplace())) break block6;
                    if (!CollectionUtil.isEmpty((Collection)members.getValuesToAdd())) {
                        for (Object group : CollectionUtil.nullAsEmpty((List)members.getValuesToAdd())) {
                            membersToAdd.add(group.toString());
                        }
                    }
                    if (CollectionUtil.isEmpty((Collection)members.getValuesToRemove())) break block7;
                    for (Object group : CollectionUtil.nullAsEmpty((List)members.getValuesToRemove())) {
                        membersToRemove.add(group.toString());
                    }
                    break block7;
                }
                for (Map<String, String> member : MembersHandler.listMembers(membersService, this.uid.getUidValue(), null)) {
                    membersToRemove.add(member.get("email"));
                }
                if (!CollectionUtil.isEmpty((Collection)members.getValuesToAdd())) {
                    for (Map<String, String> group : CollectionUtil.nullAsEmpty((List)members.getValuesToReplace())) {
                        membersToAdd.add(group.toString());
                    }
                }
            }
        });
        for (String member : membersToRemove) {
            GoogleApiExecutor.execute(MembersHandler.delete(membersService, this.uid.getUidValue(), member), new RequestResultHandler<Directory.Members.Delete, Void, Object>(){

                @Override
                public Object handleResult(Directory.Members.Delete request, Void value) {
                    return null;
                }

                @Override
                public Object handleNotFound(IOException e) {
                    return null;
                }
            });
        }
        for (String member : membersToAdd) {
            GoogleApiExecutor.execute(MembersHandler.create(membersService, this.uid.getUidValue(), member, null), new RequestResultHandler<Directory.Members.Insert, Member, Object>(){

                @Override
                public Object handleResult(Directory.Members.Insert request, Member value) {
                    return null;
                }

                @Override
                public Object handleDuplicate(IOException e) {
                    return null;
                }
            });
        }
        Directory.Groups.Aliases aliasService = this.configuration.getDirectory().groups().aliases();
        HashSet aliasesToAdd = new HashSet();
        HashSet aliasesToRemove = new HashSet();
        Optional.ofNullable(AttributeDeltaUtil.find((String)"aliases", modifications)).ifPresent(aliases -> {
            block6: {
                block5: {
                    if (!CollectionUtil.isEmpty((Collection)aliases.getValuesToReplace())) break block5;
                    if (!CollectionUtil.isEmpty((Collection)aliases.getValuesToAdd())) {
                        for (Object alias : CollectionUtil.nullAsEmpty((List)aliases.getValuesToAdd())) {
                            aliasesToAdd.add(alias.toString());
                        }
                    }
                    if (CollectionUtil.isEmpty((Collection)aliases.getValuesToRemove())) break block6;
                    for (Object alias : CollectionUtil.nullAsEmpty((List)aliases.getValuesToRemove())) {
                        aliasesToRemove.add(alias.toString());
                    }
                    break block6;
                }
                aliasesToRemove.addAll(GroupHandler.listAliases(aliasService, this.uid.getUidValue()));
                if (!CollectionUtil.isEmpty((Collection)aliases.getValuesToAdd())) {
                    for (Object group : CollectionUtil.nullAsEmpty((List)aliases.getValuesToReplace())) {
                        aliasesToAdd.add(group.toString());
                    }
                }
            }
        });
        for (String alias : aliasesToRemove) {
            GoogleApiExecutor.execute(GroupHandler.deleteGroupAlias(aliasService, alias, this.uid.getUidValue()), new RequestResultHandler<Directory.Groups.Aliases.Delete, Void, Object>(){

                @Override
                public Object handleResult(Directory.Groups.Aliases.Delete request, Void v) {
                    return null;
                }

                @Override
                public Object handleNotFound(IOException e) {
                    return null;
                }
            });
        }
        for (String alias : aliasesToAdd) {
            GoogleApiExecutor.execute(GroupHandler.createGroupAlias(aliasService, this.uid.getUidValue(), alias), new RequestResultHandler<Directory.Groups.Aliases.Insert, Alias, Object>(){

                @Override
                public Object handleResult(Directory.Groups.Aliases.Insert insert, Alias value) {
                    return null;
                }

                @Override
                public Object handleDuplicate(IOException e) {
                    return null;
                }
            });
        }
    }

    public Set<AttributeDelta> updateDelta(Set<AttributeDelta> modifications) {
        if (ObjectClass.ACCOUNT.equals((Object)this.objectClass)) {
            this.updateDeltaUser(modifications);
        } else if (ObjectClass.GROUP.equals((Object)this.objectClass)) {
            this.updateDeltaGroup(modifications);
        } else if (GoogleAppsUtil.ORG_UNIT.equals((Object)this.objectClass)) {
            Directory.Orgunits.Update update = OrgunitsHandler.update(this.configuration.getDirectory().orgunits(), this.uid.getUidValue(), modifications);
            if (null != update) {
                GoogleApiExecutor.execute(update, new RequestResultHandler<Directory.Orgunits.Update, OrgUnit, Uid>(){

                    @Override
                    public Uid handleResult(Directory.Orgunits.Update request, OrgUnit value) {
                        LOG.ok("OrgUnit is updated:{0}", new Object[]{value.getName()});
                        return GoogleAppsUpdate.this.uid;
                    }
                });
            }
        } else {
            throw new UnsupportedOperationException("Update delta of type " + this.objectClass.getObjectClassValue() + " is not supported");
        }
        return modifications;
    }
}

