/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jelly;

import com.sun.script.jelly.JellyScriptEngineFactory;
import com.sun.script.jelly.ScriptJellyContext;
import com.sun.script.jelly.ScriptTagLibrary;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.parser.XMLParser;
import org.xml.sax.XMLReader;

public class JellyScriptEngine
extends AbstractScriptEngine
implements Compilable {
    public static final String JELLY_OUTPUT = "com.sun.script.jelly.output";
    private ScriptEngineFactory factory;
    private ScriptTagLibrary scriptTagLibrary = new ScriptTagLibrary();
    public static final String ROOT_URL = "com.sun.script.jelly.root_url";
    public static final String CURRENT_URL = "com.sun.script.jelly.current_url";

    public CompiledScript compile(String str) throws ScriptException {
        return this.compile(new StringReader(str));
    }

    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compileJelly(reader, this.context);
    }

    public Object eval(String str, ScriptContext ctx) throws ScriptException {
        return this.eval((Reader)new StringReader(str), ctx);
    }

    public Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        return this.evalScript(this.compileJelly(reader, ctx), ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngineFactory getFactory() {
        JellyScriptEngine jellyScriptEngine = this;
        synchronized (jellyScriptEngine) {
            if (this.factory == null) {
                this.factory = new JellyScriptEngineFactory();
            }
        }
        return this.factory;
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    void setFactory(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    private JellyCompiledScript compileJelly(Reader reader, ScriptContext ctx) throws ScriptException {
        ctx.setAttribute("context", ctx, 100);
        ctx.setAttribute("engine", this, 100);
        ScriptJellyContext jctx = new ScriptJellyContext(new JellyContext(), ctx);
        ctx.setAttribute("jcontext", (Object)jctx, 100);
        jctx.registerTagLibrary("jelly:core", (TagLibrary)this.scriptTagLibrary);
        XMLParser parser = new XMLParser();
        parser.setExpressionFactory(this.scriptTagLibrary.getExpressionFactory());
        parser.setContext((JellyContext)jctx);
        try {
            Script script = parser.parse(reader);
            script = script.compile();
            return new JellyCompiledScript(script, jctx);
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
    }

    private Object evalScript(JellyCompiledScript jcs, ScriptContext ctx) throws ScriptException {
        ctx.setAttribute("context", ctx, 100);
        ctx.setAttribute("engine", this, 100);
        try {
            XMLOutput output = null;
            int scope = ctx.getAttributesScope(JELLY_OUTPUT);
            if (scope != -1) {
                Object o = ctx.getAttribute(JELLY_OUTPUT, scope);
                if (o instanceof OutputStream) {
                    output = XMLOutput.createXMLOutput((OutputStream)((OutputStream)o), (boolean)false);
                } else if (o instanceof Writer) {
                    output = XMLOutput.createXMLOutput((Writer)((Writer)o), (boolean)false);
                } else if (o instanceof XMLReader) {
                    output = XMLOutput.createXMLOutput((XMLReader)((XMLReader)o));
                }
            }
            if (output == null) {
                output = XMLOutput.createXMLOutput((Writer)ctx.getWriter(), (boolean)false);
            }
            ScriptJellyContext newJctx = new ScriptJellyContext(jcs.getJellyContext(), ctx);
            ctx.setAttribute("jcontext", (Object)newJctx, 100);
            newJctx.registerTagLibrary("jelly:core", (TagLibrary)this.scriptTagLibrary);
            Script script = jcs.getScript();
            script.run((JellyContext)newJctx, output);
            output.flush();
            return null;
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
    }

    static Object access$000(JellyScriptEngine x0, JellyCompiledScript x1, ScriptContext x2) throws ScriptException {
        return x0.evalScript(x1, x2);
    }

    private class JellyCompiledScript
    extends CompiledScript {
        private Script script;
        private JellyContext jctx;

        JellyCompiledScript(Script script, JellyContext jctx) {
            this.script = script;
            this.jctx = jctx;
        }

        Script getScript() {
            return this.script;
        }

        JellyContext getJellyContext() {
            return this.jctx;
        }

        public ScriptEngine getEngine() {
            return JellyScriptEngine.this;
        }

        public Object eval(ScriptContext ctx) throws ScriptException {
            return JellyScriptEngine.access$000(JellyScriptEngine.this, this, ctx);
        }
    }
}

