/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base.threads.watermark;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.transport.base.threads.watermark.WaterMarkQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWaterMarkQueue<T>
implements WaterMarkQueue<T> {
    private volatile ArrayBlockingQueue<T> waterMarkQueue;
    private volatile Queue<T> afterWaterMarkQueue;
    private Lock lock = new ReentrantLock();

    public DefaultWaterMarkQueue(int waterMark) {
        this.afterWaterMarkQueue = new LinkedBlockingQueue<T>();
        this.waterMarkQueue = new ArrayBlockingQueue(waterMark);
    }

    public DefaultWaterMarkQueue(int waterMark, int size) {
        if (waterMark > size) {
            throw new IllegalArgumentException("Size should be equal or greater than water mark");
        }
        this.afterWaterMarkQueue = new ArrayBlockingQueue<T>(size - waterMark);
        this.waterMarkQueue = new ArrayBlockingQueue(waterMark);
    }

    @Override
    public boolean add(T t) {
        return this.waterMarkQueue.add(t);
    }

    @Override
    public boolean offer(T t) {
        return this.waterMarkQueue.offer(t);
    }

    @Override
    public T remove() {
        Object t = this.waterMarkQueue.remove();
        this.tryMoveTasks();
        return (T)t;
    }

    @Override
    public T poll() {
        T t = this.waterMarkQueue.poll();
        this.tryMoveTasks();
        return t;
    }

    @Override
    public T element() {
        return (T)this.waterMarkQueue.element();
    }

    @Override
    public T peek() {
        return this.waterMarkQueue.peek();
    }

    @Override
    public void put(T t) throws InterruptedException {
        this.waterMarkQueue.put(t);
    }

    @Override
    public boolean offer(T t, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.waterMarkQueue.offer(t, l, timeUnit);
    }

    @Override
    public T take() throws InterruptedException {
        T t = this.waterMarkQueue.take();
        this.tryMoveTasks();
        return t;
    }

    @Override
    public T poll(long l, TimeUnit timeUnit) throws InterruptedException {
        T t = this.waterMarkQueue.poll(l, timeUnit);
        this.tryMoveTasks();
        return t;
    }

    @Override
    public int remainingCapacity() {
        return this.waterMarkQueue.remainingCapacity();
    }

    @Override
    public boolean remove(Object o) {
        boolean b = this.waterMarkQueue.remove(o);
        this.tryMoveTasks();
        return b;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.waterMarkQueue.containsAll(objects);
    }

    @Override
    public boolean addAll(Collection<? extends T> ts) {
        return this.waterMarkQueue.addAll(ts);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        boolean b = this.waterMarkQueue.removeAll(objects);
        this.tryMoveTasks();
        return b;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        return this.waterMarkQueue.retainAll(objects);
    }

    @Override
    public void clear() {
        this.waterMarkQueue.clear();
        this.afterWaterMarkQueue.clear();
    }

    @Override
    public int size() {
        return this.waterMarkQueue.size() + this.afterWaterMarkQueue.size();
    }

    @Override
    public boolean isEmpty() {
        this.tryMoveTasks();
        return this.waterMarkQueue.isEmpty();
    }

    private void tryMoveTasks() {
        if (this.afterWaterMarkQueue.size() > 0) {
            this.lock.lock();
            try {
                while (this.afterWaterMarkQueue.size() > 0) {
                    T w = this.afterWaterMarkQueue.poll();
                    boolean offer = this.waterMarkQueue.offer(w);
                    if (offer) continue;
                    this.afterWaterMarkQueue.offer(w);
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.waterMarkQueue.contains(o) || this.afterWaterMarkQueue.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl();
    }

    @Override
    public Object[] toArray() {
        return this.waterMarkQueue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        T[] waterMarkArray = this.waterMarkQueue.toArray(ts);
        T[] afterWaterMarkArray = this.afterWaterMarkQueue.toArray(ts);
        int alen = waterMarkArray.length;
        int blen = afterWaterMarkArray.length;
        if (alen == 0) {
            return afterWaterMarkArray;
        }
        if (blen == 0) {
            return waterMarkArray;
        }
        Object[] result = (Object[])Array.newInstance(waterMarkArray.getClass().getComponentType(), alen + blen);
        System.arraycopy(waterMarkArray, 0, result, 0, alen);
        System.arraycopy(afterWaterMarkArray, 0, result, alen, blen);
        return result;
    }

    @Override
    public int drainTo(Collection<? super T> objects) {
        int n = this.waterMarkQueue.drainTo(objects);
        this.tryMoveTasks();
        return n;
    }

    @Override
    public int drainTo(Collection<? super T> objects, int i) {
        int n = this.waterMarkQueue.drainTo(objects, i);
        this.tryMoveTasks();
        return n;
    }

    @Override
    public boolean offerAfter(T t) {
        this.lock.lock();
        try {
            boolean bl = this.afterWaterMarkQueue.offer(t);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorImpl
    implements Iterator<T> {
        Iterator<T> waterMarkIterator = null;
        Iterator<T> afterWaterMarkIterator = null;
        boolean waterMarkQueueDone = false;

        private IteratorImpl() {
            this.waterMarkIterator = DefaultWaterMarkQueue.this.waterMarkQueue.iterator();
            this.afterWaterMarkIterator = DefaultWaterMarkQueue.this.afterWaterMarkQueue.iterator();
            this.waterMarkQueueDone = false;
        }

        @Override
        public boolean hasNext() {
            return this.waterMarkIterator.hasNext() || this.afterWaterMarkIterator.hasNext();
        }

        @Override
        public T next() {
            DefaultWaterMarkQueue.this.lock.lock();
            try {
                if (this.waterMarkIterator.hasNext()) {
                    Object t = this.waterMarkIterator.next();
                    return t;
                }
                this.waterMarkQueueDone = true;
                Object t = this.afterWaterMarkIterator.next();
                return t;
            }
            finally {
                DefaultWaterMarkQueue.this.lock.unlock();
            }
        }

        @Override
        public void remove() {
            if (!this.waterMarkQueueDone) {
                this.waterMarkIterator.remove();
            } else {
                this.afterWaterMarkIterator.remove();
            }
        }
    }
}

