/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.security.authorization.ProviderCtx;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AllPermissionProviderImpl
implements PermissionProvider,
AggregatedPermissionProvider {
    private static final Set<String> ALL = Collections.singleton("jcr:all");
    private final Root root;
    private final ProviderCtx providerCtx;
    private Root immutableRoot;

    public AllPermissionProviderImpl(@NotNull Root root, @NotNull ProviderCtx providerCtx) {
        this.root = root;
        this.providerCtx = providerCtx;
        this.immutableRoot = providerCtx.getRootProvider().createReadOnlyRoot(root);
    }

    @Override
    public void refresh() {
        this.immutableRoot = this.providerCtx.getRootProvider().createReadOnlyRoot(this.root);
    }

    @Override
    @NotNull
    public Set<String> getPrivileges(@Nullable Tree tree) {
        return ALL;
    }

    @Override
    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        return true;
    }

    @Override
    @NotNull
    public RepositoryPermission getRepositoryPermission() {
        return RepositoryPermission.ALL;
    }

    @Override
    @NotNull
    public TreePermission getTreePermission(@NotNull Tree tree, @NotNull TreePermission parentPermission) {
        return TreePermission.ALL;
    }

    @Override
    public boolean isGranted(@NotNull Tree tree, @Nullable PropertyState property, long permissions) {
        return true;
    }

    @Override
    public boolean isGranted(@NotNull String oakPath, @NotNull String jcrActions) {
        return true;
    }

    @Override
    @NotNull
    public PrivilegeBits supportedPrivileges(@Nullable Tree tree, @Nullable PrivilegeBits privilegeBits) {
        return privilegeBits != null ? privilegeBits : new PrivilegeBitsProvider(this.immutableRoot).getBits("jcr:all");
    }

    @Override
    public long supportedPermissions(@Nullable Tree tree, @Nullable PropertyState property, long permissions) {
        return permissions;
    }

    @Override
    public long supportedPermissions(@NotNull TreeLocation location, long permissions) {
        return permissions;
    }

    @Override
    public long supportedPermissions(@NotNull TreePermission treePermission, PropertyState property, long permissions) {
        return permissions;
    }

    @Override
    public boolean isGranted(@NotNull TreeLocation location, long permissions) {
        return true;
    }

    @Override
    @NotNull
    public TreePermission getTreePermission(@NotNull Tree tree, @NotNull TreeType type, @NotNull TreePermission parentPermission) {
        return TreePermission.ALL;
    }
}

