/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.query;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.commons.iterator.RowIteratorAdapter;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.query.PrefetchIterator;
import org.apache.jackrabbit.oak.jcr.query.RowImpl;
import org.apache.jackrabbit.oak.jcr.session.NodeImpl;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.plugins.value.jcr.PartialValueFactory;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultImpl
implements QueryResult {
    private static final Logger queryOpsLogger = LoggerFactory.getLogger((String)"org.apache.jackrabbit.oak.jcr.operations.query");
    static final Logger LOG = LoggerFactory.getLogger(QueryResultImpl.class);
    protected final SessionContext sessionContext;
    final Result result;
    private final SessionDelegate sessionDelegate;
    private final PartialValueFactory valueFactory;

    public QueryResultImpl(SessionContext sessionContext, Result result) {
        this.sessionContext = sessionContext;
        this.sessionDelegate = sessionContext.getSessionDelegate();
        this.result = result;
        this.valueFactory = new PartialValueFactory(sessionContext, sessionContext.getBlobAccessProvider());
    }

    public String[] getColumnNames() throws RepositoryException {
        return this.result.getColumnNames();
    }

    public String[] getSelectorNames() {
        return this.result.getSelectorNames();
    }

    public RowIterator getRows() throws RepositoryException {
        Iterator<RowImpl> rowIterator = new Iterator<RowImpl>(){
            private final Iterator<? extends ResultRow> it;
            private final String pathSelector;
            private RowImpl current;
            private int rowCount;
            private final boolean debugEnabled;
            {
                this.it = QueryResultImpl.this.result.getRows().iterator();
                this.debugEnabled = queryOpsLogger.isDebugEnabled();
                String[] columnSelectorNames = QueryResultImpl.this.result.getColumnSelectorNames();
                this.pathSelector = columnSelectorNames.length == 1 ? columnSelectorNames[0] : null;
                this.fetch();
            }

            private void fetch() {
                if (this.it.hasNext()) {
                    this.current = new RowImpl(QueryResultImpl.this, this.it.next(), this.pathSelector);
                    if (this.debugEnabled) {
                        ++this.rowCount;
                        if (this.rowCount % 100 == 0) {
                            queryOpsLogger.debug("Iterated over [{}] results so far", (Object)this.rowCount);
                        }
                    }
                } else {
                    this.current = null;
                }
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public RowImpl next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                RowImpl r = this.current;
                this.fetch();
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        final PrefetchIterator<RowImpl> prefIt = new PrefetchIterator<RowImpl>(this.sessionDelegate.sync(rowIterator), new PrefetchIterator.PrefetchOptions(){
            {
                this.size = QueryResultImpl.this.result.getSize();
                this.fastSize = QueryResultImpl.this.sessionContext.getFastQueryResultSize();
                this.fastSizeCallback = QueryResultImpl.this.result;
            }
        });
        return new RowIteratorAdapter(prefIt){

            @Override
            public long getSize() {
                return prefIt.size();
            }
        };
    }

    @Nullable
    NodeImpl<? extends NodeDelegate> getNode(Tree tree) throws RepositoryException {
        if (tree != null && tree.exists()) {
            NodeDelegate node = new NodeDelegate(this.sessionDelegate, tree);
            return NodeImpl.createNode(node, this.sessionContext);
        }
        return null;
    }

    public NodeIterator getNodes() throws RepositoryException {
        Object[] columnSelectorNames = this.result.getColumnSelectorNames();
        if (columnSelectorNames.length != 1) {
            throw new RepositoryException("Query contains more than one selector: " + Arrays.toString(columnSelectorNames));
        }
        final String selectorName = columnSelectorNames[0];
        if (selectorName == null) {
            throw new RepositoryException("Query does not contain a selector: " + Arrays.toString(columnSelectorNames));
        }
        Iterator<NodeImpl<? extends NodeDelegate>> nodeIterator = new Iterator<NodeImpl<? extends NodeDelegate>>(){
            private final Iterator<? extends ResultRow> it;
            private NodeImpl<? extends NodeDelegate> current;
            {
                this.it = QueryResultImpl.this.result.getRows().iterator();
                this.fetch();
            }

            private void fetch() {
                this.current = null;
                while (this.it.hasNext()) {
                    ResultRow r = this.it.next();
                    Tree tree = r.getTree(selectorName);
                    if (tree == null || !tree.exists()) continue;
                    try {
                        this.current = QueryResultImpl.this.getNode(tree);
                        break;
                    }
                    catch (RepositoryException e) {
                        LOG.warn("Unable to fetch result node for path " + tree.getPath(), (Throwable)e);
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public NodeImpl<? extends NodeDelegate> next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                NodeImpl<? extends NodeDelegate> n = this.current;
                this.fetch();
                return n;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        final PrefetchIterator<NodeImpl<? extends NodeDelegate>> prefIt = new PrefetchIterator<NodeImpl<? extends NodeDelegate>>(this.sessionDelegate.sync(nodeIterator), new PrefetchIterator.PrefetchOptions(){
            {
                this.size = QueryResultImpl.this.result.getSize();
                this.fastSize = QueryResultImpl.this.sessionContext.getFastQueryResultSize();
                this.fastSizeCallback = QueryResultImpl.this.result;
            }
        });
        return new NodeIteratorAdapter(prefIt){

            @Override
            public long getSize() {
                return prefIt.size();
            }
        };
    }

    Value createValue(PropertyValue value) {
        if (value == null) {
            return null;
        }
        PropertyState state = PropertyValues.create(value);
        if (state == null) {
            throw new IllegalArgumentException("Failed to convert the specified property value to a property state.");
        }
        return this.valueFactory.createValue(state);
    }
}

