/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.oak.restrictions.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.AbstractRestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinitionImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.sling.oak.restrictions.impl.ResourceTypePattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={RestrictionProvider.class})
public class SlingRestrictionProviderImpl
extends AbstractRestrictionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SlingRestrictionProviderImpl.class);
    public static final String SLING_RESOURCE_TYPES = "sling:resourceTypes";
    public static final String SLING_RESOURCE_TYPES_WITH_DESCENDANTS = "sling:resourceTypesWithDescendants";

    public SlingRestrictionProviderImpl() {
        super(SlingRestrictionProviderImpl.supportedRestrictions());
    }

    private static Map<String, RestrictionDefinition> supportedRestrictions() {
        RestrictionDefinitionImpl slingResourceTypes = new RestrictionDefinitionImpl(SLING_RESOURCE_TYPES, Type.STRINGS, false);
        RestrictionDefinitionImpl slingResourceTypesWithChildren = new RestrictionDefinitionImpl(SLING_RESOURCE_TYPES_WITH_DESCENDANTS, Type.STRINGS, false);
        HashMap<String, RestrictionDefinitionImpl> supportedRestrictions = new HashMap<String, RestrictionDefinitionImpl>();
        supportedRestrictions.put(slingResourceTypes.getName(), slingResourceTypes);
        supportedRestrictions.put(slingResourceTypesWithChildren.getName(), slingResourceTypesWithChildren);
        return Collections.unmodifiableMap(supportedRestrictions);
    }

    @NotNull
    public RestrictionPattern getPattern(String oakPath, @NotNull Tree tree) {
        if (oakPath != null) {
            PropertyState resourceTypes = tree.getProperty(SLING_RESOURCE_TYPES);
            if (resourceTypes != null) {
                ResourceTypePattern resourceTypePattern = new ResourceTypePattern((Iterable)resourceTypes.getValue(Type.STRINGS), oakPath, false);
                LOG.trace("Returning resourceTypePattern={} for rep:slingResourceTypes in getPattern(String,Tree)", (Object)resourceTypePattern);
                return resourceTypePattern;
            }
            PropertyState resourceTypesWithChildren = tree.getProperty(SLING_RESOURCE_TYPES_WITH_DESCENDANTS);
            if (resourceTypesWithChildren != null) {
                ResourceTypePattern resourceTypePattern = new ResourceTypePattern((Iterable)resourceTypesWithChildren.getValue(Type.STRINGS), oakPath, true);
                LOG.trace("Returning resourceTypePattern={} for rep:slingResourceTypesWithChildren in getPattern(String,Tree)", (Object)resourceTypePattern);
                return resourceTypePattern;
            }
        }
        return RestrictionPattern.EMPTY;
    }

    @NotNull
    public RestrictionPattern getPattern(@Nullable String oakPath, @NotNull Set<Restriction> restrictions) {
        if (oakPath != null && !restrictions.isEmpty()) {
            for (Restriction r : restrictions) {
                String name = r.getDefinition().getName();
                if (SLING_RESOURCE_TYPES.equals(name)) {
                    ResourceTypePattern resourceTypePattern = new ResourceTypePattern((Iterable)r.getProperty().getValue(Type.STRINGS), oakPath, false);
                    LOG.trace("Returning resourceTypePattern={} for rep:slingResourceTypes in getPattern(String,Set<Restriction>)", (Object)resourceTypePattern);
                    return resourceTypePattern;
                }
                if (!SLING_RESOURCE_TYPES_WITH_DESCENDANTS.equals(name)) continue;
                ResourceTypePattern resourceTypePattern = new ResourceTypePattern((Iterable)r.getProperty().getValue(Type.STRINGS), oakPath, true);
                LOG.trace("Returning resourceTypePattern={} for rep:slingResourceTypesWithChildren in getPattern(String,Set<Restriction>)", (Object)resourceTypePattern);
                return resourceTypePattern;
            }
        }
        return RestrictionPattern.EMPTY;
    }
}

