/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.generic.resource.impl;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.nosql.generic.adapter.NoSqlAdapter;
import org.apache.sling.nosql.generic.adapter.NoSqlData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValueMapConvertingNoSqlAdapter
implements NoSqlAdapter {
    private static final String PREFIX_CALENDAR = "{{calendar}}";
    private static final String PREFIX_BYTE_ARRAY = "{{bytes}}";
    private final NoSqlAdapter delegate;
    private static final Logger log = LoggerFactory.getLogger(ValueMapConvertingNoSqlAdapter.class);

    public ValueMapConvertingNoSqlAdapter(NoSqlAdapter delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean validPath(String path) {
        return this.delegate.validPath(path);
    }

    @Override
    public NoSqlData get(String path) {
        return this.deserializeUnsupportedTypes(this.delegate.get(path));
    }

    @Override
    public Iterator<NoSqlData> getChildren(String parentPath) {
        return this.deserializeUnsupportedTypes(this.delegate.getChildren(parentPath));
    }

    @Override
    public boolean store(NoSqlData data) {
        return this.delegate.store(this.serializeUnsupportedTypes(data));
    }

    @Override
    public boolean deleteRecursive(String path) {
        return this.delegate.deleteRecursive(path);
    }

    @Override
    public Iterator<NoSqlData> query(String query, String language) {
        return this.deserializeUnsupportedTypes(this.delegate.query(query, language));
    }

    private Iterator<NoSqlData> deserializeUnsupportedTypes(final Iterator<NoSqlData> source) {
        if (source == null) {
            return null;
        }
        return new Iterator<NoSqlData>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public NoSqlData next() {
                return ValueMapConvertingNoSqlAdapter.this.deserializeUnsupportedTypes((NoSqlData)source.next());
            }

            @Override
            public void remove() {
                source.remove();
            }
        };
    }

    private NoSqlData serializeUnsupportedTypes(NoSqlData data) {
        if (data == null) {
            return null;
        }
        HashMap<String, Object> serializedMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : data.getProperties().entrySet()) {
            Object serializedValue = entry.getValue();
            if (entry.getValue() instanceof Calendar) {
                serializedValue = PREFIX_CALENDAR + ValueMapConvertingNoSqlAdapter.getISO8601Format().format(((Calendar)entry.getValue()).getTime());
            } else if (entry.getValue() instanceof byte[]) {
                serializedValue = PREFIX_BYTE_ARRAY + DatatypeConverter.printBase64Binary((byte[])((byte[])entry.getValue()));
            }
            serializedMap.put(entry.getKey(), serializedValue);
        }
        return new NoSqlData(data.getPath(), serializedMap);
    }

    private NoSqlData deserializeUnsupportedTypes(NoSqlData data) {
        if (data == null) {
            return null;
        }
        HashMap<String, Object> deserializedMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : data.getProperties().entrySet()) {
            Object deserializedValue = entry.getValue();
            if (entry.getValue() instanceof String) {
                String value = (String)entry.getValue();
                if (value.indexOf(PREFIX_CALENDAR) == 0) {
                    String calendarValue = value.substring(PREFIX_CALENDAR.length());
                    try {
                        Date date = ValueMapConvertingNoSqlAdapter.getISO8601Format().parse(calendarValue);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        deserializedValue = calendar;
                    }
                    catch (ParseException ex) {
                        log.warn("Unable to parse serialized calendar value: " + entry.getValue(), (Throwable)ex);
                    }
                } else if (value.indexOf(PREFIX_BYTE_ARRAY) == 0) {
                    String byteArrayValue = value.substring(PREFIX_BYTE_ARRAY.length());
                    deserializedValue = DatatypeConverter.parseBase64Binary((String)byteArrayValue);
                }
            }
            deserializedMap.put(entry.getKey(), deserializedValue);
        }
        return new NoSqlData(data.getPath(), deserializedMap);
    }

    @Override
    public void checkConnection() throws LoginException {
        this.delegate.checkConnection();
    }

    @Override
    public void createIndexDefinitions() {
        this.delegate.createIndexDefinitions();
    }

    private static DateFormat getISO8601Format() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
    }
}

