/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.packageinit.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.packaging.registry.ExecutionPlan;
import org.apache.jackrabbit.vault.packaging.registry.ExecutionPlanBuilder;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.PackageTask;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.api.SlingRepositoryInitializer;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingRepositoryInitializer.class})
@Designate(ocd=Config.class)
@ServiceRanking(value=200)
public class ExecutionPlanRepoInitializer
implements SlingRepositoryInitializer {
    private static final String EXECUTEDPLANS_FILE = "executedplans.file";
    private File statusFile;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private BundleContext context;
    private Config config;

    @Activate
    private void activate(BundleContext context, Config config) {
        this.context = context;
        this.config = config;
    }

    private static boolean isCandidateProcessed(String candidate, Set<Integer> executedHashes) {
        return executedHashes.contains(candidate.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRepository(SlingRepository slingRepository) throws Exception {
        block29: {
            List<String> epCandidates = Arrays.asList(this.config.executionplans());
            HashSet<Integer> executedHashes = new HashSet<Integer>();
            if (StringUtils.isEmpty((CharSequence)this.config.statusfilepath())) {
                this.statusFile = this.context.getDataFile(EXECUTEDPLANS_FILE);
            } else {
                Path statusFilePath = Paths.get(this.config.statusfilepath(), new String[0]);
                if (statusFilePath.isAbsolute()) {
                    this.statusFile = statusFilePath.toFile();
                } else {
                    throw new IllegalStateException("Only absolute paths supported");
                }
            }
            if (this.statusFile.exists()) {
                try (BufferedReader br = new BufferedReader(new FileReader(this.statusFile));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        executedHashes.add(Integer.parseInt(line));
                    }
                }
            }
            if (!epCandidates.isEmpty()) {
                try (ServiceTracker st = new ServiceTracker(this.context, PackageRegistry.class, null);){
                    st.open();
                    this.logger.info("Waiting for PackageRegistry.");
                    PackageRegistry registry = (PackageRegistry)st.waitForService(0L);
                    this.logger.info("PackageRegistry found - starting execution of execution plan");
                    ExecutionPlanBuilder builder = registry.createExecutionPlan();
                    Session session = slingRepository.loginAdministrative(null);
                    try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.statusFile));){
                        for (String plan : epCandidates) {
                            boolean checkIfCandidateWasProcessed;
                            builder.load((InputStream)new ByteArrayInputStream(plan.getBytes(StandardCharsets.UTF_8)));
                            builder.with(session);
                            boolean planHasSnapshot = builder.preview().stream().anyMatch(p -> p.getVersionString().endsWith("-SNAPSHOT"));
                            boolean bl = checkIfCandidateWasProcessed = !planHasSnapshot || !this.config.reinstallSnapshots();
                            if (checkIfCandidateWasProcessed && ExecutionPlanRepoInitializer.isCandidateProcessed(plan, executedHashes)) continue;
                            ExecutionPlan xplan = builder.execute();
                            if (xplan.getTasks().size() > 0) {
                                if (xplan.hasErrors()) {
                                    IllegalStateException ex = new IllegalStateException("Execution plan contained errors - cannot complete repository initialization.");
                                    for (PackageTask task : xplan.getTasks()) {
                                        if (!PackageTask.State.ERROR.equals((Object)task.getState())) continue;
                                        ex.addSuppressed(task.getError());
                                    }
                                    throw ex;
                                }
                                this.logger.info("Execution plan executed with {} entries", (Object)xplan.getTasks().size());
                            } else {
                                this.logger.info("No tasks found in execution plan - no additional packages installed.");
                            }
                            writer.write(String.valueOf(plan.hashCode()));
                            writer.newLine();
                        }
                        break block29;
                    }
                    finally {
                        session.logout();
                    }
                }
            }
            this.logger.info("No execution plans configured - skipping init.");
        }
    }

    @ObjectClassDefinition(name="Execution plan based Repository Initializer")
    static @interface Config {
        @AttributeDefinition
        public String statusfilepath() default "";

        @AttributeDefinition
        public String[] executionplans() default {};

        @AttributeDefinition
        public boolean reinstallSnapshots() default false;
    }
}

