/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its.setup.mock;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtificialDelay {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Long> operationsMap = new ConcurrentHashMap<String, Long>();
    private String debugName;
    private final Object syncObj = new Object();

    public void setDebugName(String debugName) {
        this.debugName = debugName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelay(String operationDescriptor, long delayMillis) {
        this.operationsMap.put(operationDescriptor, delayMillis);
        Object object = this.syncObj;
        synchronized (object) {
            this.syncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delay(String operationDescriptor) {
        Long delayMillis = this.operationsMap.get(operationDescriptor);
        if (delayMillis == null) {
            return;
        }
        if (delayMillis <= 0L) {
            return;
        }
        this.logger.info("delay: delaying [" + this.debugName + "] '" + operationDescriptor + "' for " + delayMillis + "ms...");
        long start = System.currentTimeMillis();
        Object object = this.syncObj;
        synchronized (object) {
            while (true) {
                if ((delayMillis = this.operationsMap.get(operationDescriptor)) == null) {
                    this.logger.info("delay: delaying [" + this.debugName + "]'" + operationDescriptor + "' for " + delayMillis + "ms done.");
                    return;
                }
                if (delayMillis <= 0L) {
                    this.logger.info("delay: delaying [" + this.debugName + "]'" + operationDescriptor + "' for " + delayMillis + "ms done.");
                    return;
                }
                long end = start + delayMillis;
                long remaining = end - System.currentTimeMillis();
                if (remaining <= 0L) {
                    // MONITOREXIT @DISABLED, blocks:[2, 4, 5] lbl22 : MonitorExitStatement: MONITOREXIT : var5_4
                    this.logger.info("delay: delaying [" + this.debugName + "]'" + operationDescriptor + "' for " + delayMillis + "ms done.");
                    return;
                }
                try {
                    this.logger.info("delay: delaying [" + this.debugName + "] '" + operationDescriptor + "' now for " + remaining + "ms...");
                    this.syncObj.wait(remaining);
                }
                catch (InterruptedException e) {
                    this.logger.error("delay: got interrupted: " + e, (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

