/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.its;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Level;
import org.apache.log4j.spi.RootLogger;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.base.commons.UndefinedClusterViewException;
import org.apache.sling.discovery.base.its.setup.VirtualInstance;
import org.apache.sling.discovery.base.its.setup.VirtualInstanceBuilder;
import org.apache.sling.discovery.base.its.setup.mock.AssertingTopologyEventListener;
import org.apache.sling.discovery.base.its.setup.mock.PropertyProviderImpl;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSingleInstanceTest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    VirtualInstance instance;
    String propertyValue;
    private Level logLevel;

    protected abstract VirtualInstanceBuilder newBuilder();

    @Before
    public void setup() throws Exception {
        org.apache.log4j.Logger discoveryLogger = RootLogger.getLogger((String)"org.apache.sling.discovery");
        this.logLevel = discoveryLogger.getLevel();
        discoveryLogger.setLevel(Level.DEBUG);
        this.logger.info("setup: creating new standalone instance");
        this.instance = this.newBuilder().setDebugName("standaloneInstance").newRepository("/var/discovery/impl/", true).setConnectorPingTimeout(20).setConnectorPingInterval(999).setMinEventDelay(3).build();
        this.logger.info("setup: creating new standalone instance done.");
    }

    @After
    public void tearDown() throws Exception {
        org.apache.log4j.Logger discoveryLogger = RootLogger.getLogger((String)"org.apache.sling.discovery");
        discoveryLogger.setLevel(this.logLevel);
        this.logger.info("tearDown: stopping standalone instance");
        if (this.instance != null) {
            this.instance.stop();
            this.instance = null;
        }
        this.logger.info("tearDown: stopping standalone instance done");
    }

    @Test
    public void testGetters() throws UndefinedClusterViewException, InterruptedException {
        this.logger.info("testGetters: start");
        Assert.assertNotNull((Object)this.instance);
        this.logger.info("sling id=" + this.instance.getSlingId());
        try {
            this.instance.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        this.instance.heartbeatsAndCheckView();
        Thread.sleep(4000L);
        Assert.assertNotNull((Object)this.instance.getClusterViewService().getLocalClusterView());
        LocalClusterView cv = this.instance.getClusterViewService().getLocalClusterView();
        this.logger.info("cluster view: id=" + cv.getId());
        Assert.assertNotNull((Object)cv.getId());
        Assert.assertNotSame((Object)cv.getId(), (Object)"");
        List instances = cv.getInstances();
        Assert.assertNotNull((Object)instances);
        Assert.assertTrue((instances.size() == 1 ? 1 : 0) != 0);
        InstanceDescription myInstance = (InstanceDescription)instances.get(0);
        Assert.assertNotNull((Object)myInstance);
        Assert.assertTrue((myInstance.getClusterView() == cv ? 1 : 0) != 0);
        this.logger.info("instance id: " + myInstance.getSlingId());
        Assert.assertEquals((Object)this.instance.getSlingId(), (Object)myInstance.getSlingId());
        Map properties = myInstance.getProperties();
        Assert.assertNotNull((Object)properties);
        Assert.assertNull((Object)myInstance.getProperty("foo"));
        Assert.assertTrue((boolean)myInstance.isLeader());
        Assert.assertTrue((boolean)myInstance.isLocal());
        this.logger.info("testGetters: end");
    }

    @Test
    public void testPropertyProviders() throws Throwable {
        this.logger.info("testPropertyProviders: start");
        String propertyName = UUID.randomUUID().toString();
        this.propertyValue = UUID.randomUUID().toString();
        PropertyProviderImpl pp = new PropertyProviderImpl();
        pp.setProperty(propertyName, this.propertyValue);
        this.instance.bindPropertyProvider(pp, propertyName);
        this.instance.heartbeatsAndCheckView();
        Thread.sleep(4000L);
        Assert.assertEquals((Object)this.propertyValue, (Object)((InstanceDescription)this.instance.getClusterViewService().getLocalClusterView().getInstances().get(0)).getProperty(propertyName));
        this.propertyValue = UUID.randomUUID().toString();
        pp.setProperty(propertyName, this.propertyValue);
        this.instance.heartbeatsAndCheckView();
        Assert.assertEquals((Object)this.propertyValue, (Object)((InstanceDescription)this.instance.getClusterViewService().getLocalClusterView().getInstances().get(0)).getProperty(propertyName));
        Assert.assertNull((Object)((InstanceDescription)this.instance.getClusterViewService().getLocalClusterView().getInstances().get(0)).getProperty(UUID.randomUUID().toString()));
        this.logger.info("testPropertyProviders: end");
    }

    @Test
    public void testInvalidProperties() throws Throwable {
        this.logger.info("testInvalidProperties: start");
        this.instance.heartbeatsAndCheckView();
        this.instance.heartbeatsAndCheckView();
        String propertyValue = UUID.randomUUID().toString();
        Thread.sleep(2000L);
        this.doTestProperty(UUID.randomUUID().toString(), propertyValue, propertyValue);
        this.doTestProperty("", propertyValue, null);
        this.doTestProperty("-", propertyValue, propertyValue);
        this.doTestProperty("_", propertyValue, propertyValue);
        this.doTestProperty("jcr:" + UUID.randomUUID().toString(), propertyValue, null);
        this.doTestProperty("var/" + UUID.randomUUID().toString(), propertyValue, null);
        this.doTestProperty(UUID.randomUUID().toString() + "@test", propertyValue, null);
        this.doTestProperty(UUID.randomUUID().toString() + "!test", propertyValue, null);
        this.logger.info("testInvalidProperties: end");
    }

    private void doTestProperty(String propertyName, String propertyValue, String expectedPropertyValue) throws Throwable {
        PropertyProviderImpl pp = new PropertyProviderImpl();
        pp.setProperty(propertyName, propertyValue);
        this.instance.bindPropertyProvider(pp, propertyName);
        Assert.assertEquals((Object)expectedPropertyValue, (Object)((InstanceDescription)this.instance.getClusterViewService().getLocalClusterView().getInstances().get(0)).getProperty(propertyName));
    }

    @Test
    public void testTopologyEventListeners() throws Throwable {
        this.logger.info("testTopologyEventListeners: start");
        this.instance.heartbeatsAndCheckView();
        this.logger.info("testTopologyEventListeners: 1st sleep 2s");
        Thread.sleep(2000L);
        this.instance.heartbeatsAndCheckView();
        this.logger.info("testTopologyEventListeners: 2nd sleep 2s");
        Thread.sleep(2000L);
        AssertingTopologyEventListener assertingTopologyEventListener = new AssertingTopologyEventListener();
        assertingTopologyEventListener.addExpected(TopologyEvent.Type.TOPOLOGY_INIT);
        this.logger.info("testTopologyEventListeners: binding the event listener");
        this.instance.bindTopologyEventListener(assertingTopologyEventListener);
        Thread.sleep(1000L);
        Assert.assertEquals((long)0L, (long)assertingTopologyEventListener.getRemainingExpectedCount());
        String propertyName = UUID.randomUUID().toString();
        this.propertyValue = UUID.randomUUID().toString();
        PropertyProviderImpl pp = new PropertyProviderImpl();
        pp.setProperty(propertyName, this.propertyValue);
        assertingTopologyEventListener.addExpected(TopologyEvent.Type.PROPERTIES_CHANGED);
        Assert.assertEquals((long)1L, (long)assertingTopologyEventListener.getRemainingExpectedCount());
        Assert.assertEquals((long)0L, (long)pp.getGetCnt());
        this.instance.bindPropertyProvider(pp, propertyName);
        this.logger.info("testTopologyEventListeners: 3rd sleep 1.5s");
        Thread.sleep(1500L);
        this.logger.info("testTopologyEventListeners: dumping due to failure: ");
        assertingTopologyEventListener.dump();
        Assert.assertEquals((long)0L, (long)assertingTopologyEventListener.getRemainingExpectedCount());
        Assert.assertTrue((pp.getGetCnt() > 0 ? 1 : 0) != 0);
        assertingTopologyEventListener.addExpected(TopologyEvent.Type.PROPERTIES_CHANGED);
        Assert.assertEquals((long)1L, (long)assertingTopologyEventListener.getRemainingExpectedCount());
        pp.setGetCnt(0);
        this.propertyValue = UUID.randomUUID().toString();
        pp.setProperty(propertyName, this.propertyValue);
        Assert.assertEquals((long)0L, (long)pp.getGetCnt());
        this.instance.heartbeatsAndCheckView();
        this.logger.info("testTopologyEventListeners: 4th sleep 2s");
        Thread.sleep(2000L);
        Assert.assertEquals((long)0L, (long)assertingTopologyEventListener.getRemainingExpectedCount());
        Assert.assertEquals((long)2L, (long)pp.getGetCnt());
        this.instance.heartbeatsAndCheckView();
        this.logger.info("testTopologyEventListeners: 5th sleep 2s");
        Thread.sleep(2000L);
        Assert.assertEquals((long)0L, (long)assertingTopologyEventListener.getRemainingExpectedCount());
        Assert.assertEquals((long)3L, (long)pp.getGetCnt());
        this.logger.info("testTopologyEventListeners: done");
    }

    @Test
    public void testBootstrap() throws Throwable {
        this.logger.info("testBootstrap: start");
        try {
            this.instance.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        AssertingTopologyEventListener ada = new AssertingTopologyEventListener();
        this.instance.bindTopologyEventListener(ada);
        Assert.assertEquals((long)0L, (long)ada.getEvents().size());
        Assert.assertEquals((long)0L, (long)ada.getUnexpectedCount());
        try {
            this.instance.getClusterViewService().getLocalClusterView();
            Assert.fail((String)"should complain");
        }
        catch (UndefinedClusterViewException undefinedClusterViewException) {
            // empty catch block
        }
        ada.addExpected(TopologyEvent.Type.TOPOLOGY_INIT);
        this.instance.heartbeatsAndCheckView();
        Thread.sleep(1000L);
        this.instance.heartbeatsAndCheckView();
        Thread.sleep(1000L);
        this.logger.info("testBoostrap: dumping repo...");
        this.instance.dumpRepo();
        this.logger.info("testBoostrap: dumping listener...");
        ada.dump();
        Assert.assertEquals((long)0L, (long)ada.getUnexpectedCount());
        Assert.assertEquals((long)1L, (long)ada.getEvents().size());
        TopologyEvent initEvent = ada.getEvents().remove(0);
        Assert.assertNotNull((Object)initEvent);
        Assert.assertNotNull((Object)initEvent.getNewView());
        Assert.assertNotNull((Object)initEvent.getNewView().getClusterViews());
        this.instance.assertEstablishedView();
        this.logger.info("testBootstrap: end");
    }
}

