/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.classloader.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.commons.classloader.impl.DynamicClassLoaderManagerFactory;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PackageAdminClassLoader
extends ClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageAdminClassLoader.class);
    private final PackageAdmin packageAdmin;
    private final DynamicClassLoaderManagerFactory factory;
    private Map<String, Class<?>> classCache = new ConcurrentHashMap();
    private Set<String> negativeClassCache = Collections.synchronizedSet(new HashSet());
    private Map<String, Bundle> packageProviders = new ConcurrentHashMap<String, Bundle>();
    private Map<String, URL> urlCache = new ConcurrentHashMap<String, URL>();

    public PackageAdminClassLoader(PackageAdmin pckAdmin, ClassLoader parent, DynamicClassLoaderManagerFactory factory) {
        super(parent);
        this.packageAdmin = pckAdmin;
        this.factory = factory;
    }

    private boolean isBundleActive(Bundle bundle) {
        if (bundle != null) {
            if (bundle.getState() == 32) {
                return true;
            }
            if (bundle.getState() == 8) {
                return bundle.getHeaders().get("Bundle-ActivationPolicy") != null;
            }
        }
        return false;
    }

    private Set<Bundle> findBundlesForPackage(String pckName) {
        ExportedPackage[] exportedPackages = this.packageAdmin.getExportedPackages(pckName);
        LinkedHashSet<Bundle> bundles = new LinkedHashSet<Bundle>();
        if (exportedPackages != null) {
            for (ExportedPackage exportedPackage : exportedPackages) {
                Bundle bundle;
                if (exportedPackage.isRemovalPending() || !this.isBundleActive(bundle = exportedPackage.getExportingBundle())) continue;
                bundles.add(bundle);
            }
        }
        return bundles;
    }

    private String getPackageFromResource(String resource) {
        int lastSlash = resource.lastIndexOf(47);
        String pckName = lastSlash == -1 ? "" : resource.substring(0, lastSlash).replace('/', '.');
        return pckName;
    }

    private String getPackageFromClassName(String name) {
        int lastDot = name.lastIndexOf(46);
        String pckName = lastDot == -1 ? "" : name.substring(0, lastDot);
        return pckName;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration e = super.getResources(name);
        if (e == null || !e.hasMoreElements()) {
            String packageName = this.getPackageFromResource(name);
            Bundle providingBundle = this.packageProviders.get(packageName);
            if (providingBundle == null) {
                for (Bundle bundle : this.findBundlesForPackage(this.getPackageFromResource(name))) {
                    e = bundle.getResources(name);
                    if (e == null) continue;
                    this.packageProviders.put(packageName, bundle);
                    this.factory.addUsedBundle(bundle);
                    LOGGER.debug("Marking bundle {}:{} as the provider for API package {}.", new Object[]{bundle.getSymbolicName(), bundle.getVersion().toString(), packageName});
                    return e;
                }
            } else {
                e = providingBundle.getResources(name);
                if (e == null) {
                    LOGGER.debug("Cannot find resources {} in bundle {}:{} which was marked as the provider for package {}.", new Object[]{name, providingBundle.getSymbolicName(), providingBundle.getVersion().toString(), packageName});
                }
            }
        }
        return e;
    }

    @Override
    public URL findResource(String name) {
        URL cachedURL = this.urlCache.get(name);
        if (cachedURL != null) {
            return cachedURL;
        }
        URL url = super.findResource(name);
        if (url == null) {
            String packageName = this.getPackageFromResource(name);
            Bundle providingBundle = this.packageProviders.get(packageName);
            if (providingBundle == null) {
                Set<Bundle> bundles = this.findBundlesForPackage(this.getPackageFromResource(name));
                for (Bundle bundle : bundles) {
                    url = bundle.getResource(name);
                    if (url == null) continue;
                    this.urlCache.put(name, url);
                    this.factory.addUsedBundle(bundle);
                    this.packageProviders.put(packageName, bundle);
                    LOGGER.debug("Marking bundle {}:{} as the provider for API package {}.", new Object[]{bundle.getSymbolicName(), bundle.getVersion().toString(), packageName});
                    return url;
                }
            } else {
                url = providingBundle.getResource(name);
                if (url == null) {
                    LOGGER.debug("Cannot find resource {} in bundle {}:{} which was marked as the provider for package {}.", new Object[]{name, providingBundle.getSymbolicName(), providingBundle.getVersion().toString(), packageName});
                }
            }
        }
        return url;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        Class<?> cachedClass = this.classCache.get(name);
        if (cachedClass != null) {
            return cachedClass;
        }
        try {
            clazz = super.findClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            clazz = this.getClassFromBundles(name);
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Class not found " + name);
        }
        this.classCache.put(name, clazz);
        return clazz;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        Class<?> cachedClass = this.classCache.get(name);
        if (cachedClass != null) {
            return cachedClass;
        }
        if (this.negativeClassCache.contains(name)) {
            throw new ClassNotFoundException("Class not found " + name);
        }
        String packageName = this.getPackageFromClassName(name);
        try {
            clazz = super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                clazz = this.getClassFromBundles(name);
            }
            catch (ClassNotFoundException innerCNFE) {
                this.negativeClassCache.add(name);
                this.factory.addUnresolvedPackage(packageName);
                throw innerCNFE;
            }
        }
        if (clazz == null) {
            this.negativeClassCache.add(name);
            this.factory.addUnresolvedPackage(packageName);
            throw new ClassNotFoundException("Class not found " + name);
        }
        this.classCache.put(name, clazz);
        return clazz;
    }

    private Class<?> getClassFromBundles(String name) throws ClassNotFoundException {
        Class clazz = null;
        String packageName = this.getPackageFromClassName(name);
        Bundle providingBundle = this.packageProviders.get(packageName);
        if (providingBundle == null) {
            Set<Bundle> bundles = this.findBundlesForPackage(packageName);
            for (Bundle bundle : bundles) {
                try {
                    clazz = bundle.loadClass(name);
                    this.factory.addUsedBundle(bundle);
                    this.packageProviders.put(packageName, bundle);
                    LOGGER.debug("Marking bundle {}:{} as the provider for API package {}.", new Object[]{bundle.getSymbolicName(), bundle.getVersion().toString(), packageName});
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        } else {
            try {
                clazz = providingBundle.loadClass(name);
                this.factory.addUsedBundle(providingBundle);
            }
            catch (ClassNotFoundException icnfe) {
                throw new ClassNotFoundException(String.format("Cannot find class %s in bundle %s:%s which was marked as the provider for package %s.", name, providingBundle.getSymbolicName(), providingBundle.getVersion().toString(), packageName), icnfe);
            }
        }
        return clazz;
    }
}

