/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.publication;

import java.util.Calendar;
import java.util.Collections;
import java.util.Optional;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.PublishableResource;
import org.apache.sling.cms.publication.PUBLICATION_MODE;
import org.apache.sling.cms.publication.PublicationEvent;
import org.apache.sling.cms.publication.PublicationException;
import org.apache.sling.cms.publication.PublicationManager;
import org.apache.sling.cms.publication.PublicationType;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class StandalonePublicationManager
implements PublicationManager {
    private EventAdmin eventAdmin;

    public StandalonePublicationManager(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void publish(PublishableResource resource) throws PublicationException {
        try {
            Resource contentResource = resource.getContentResource();
            if (contentResource == null) {
                contentResource = resource.getResource().getResourceResolver().create(resource.getResource(), "jcr:content", Collections.singletonMap("jcr:primaryType", "nt:unstructured"));
            }
            ModifiableValueMap properties = Optional.ofNullable((ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class)).orElseThrow(() -> new PublicationException("Cannot modify resource"));
            properties.put((Object)"sling:published", (Object)true);
            properties.put((Object)"sling:lastPublication", (Object)Calendar.getInstance());
            properties.put((Object)"sling:lastPublicationType", (Object)PublicationType.ADD.toString());
            resource.getResource().getResourceResolver().commit();
            this.eventAdmin.postEvent((Event)PublicationEvent.publish((PublishableResource)resource, (boolean)false));
        }
        catch (PersistenceException e) {
            throw new PublicationException("Cannot save publication status", (Throwable)e);
        }
    }

    public void unpublish(PublishableResource resource) throws PublicationException {
        try {
            Resource contentResource = resource.getContentResource();
            if (contentResource == null) {
                contentResource = resource.getResource().getResourceResolver().create(resource.getResource(), "jcr:content", Collections.singletonMap("jcr:primaryType", "nt:unstructured"));
            }
            ModifiableValueMap properties = Optional.ofNullable((ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class)).orElseThrow(() -> new PublicationException("Cannot modify resource"));
            properties.put((Object)"sling:published", (Object)false);
            properties.put((Object)"sling:lastPublication", (Object)Calendar.getInstance());
            properties.put((Object)"sling:lastPublicationType", (Object)PublicationType.DELETE.toString());
            resource.getResource().getResourceResolver().commit();
            this.eventAdmin.postEvent((Event)PublicationEvent.unpublish((PublishableResource)resource, (boolean)false));
        }
        catch (PersistenceException e) {
            throw new PublicationException("Cannot save publication status", (Throwable)e);
        }
    }

    public PUBLICATION_MODE getPublicationMode() {
        return PUBLICATION_MODE.STANDALONE;
    }
}

