/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.operations;

import java.util.List;
import javax.jcr.Node;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SlingPostProcessor.class})
public class CheckoutPostOperation
implements SlingPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(CheckoutPostOperation.class);
    private static final String PN_CHECKOUT = ":checkoutPostOp";

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        if ("true".equals(request.getParameter(PN_CHECKOUT))) {
            Resource resource = request.getResource();
            Node node = (Node)resource.adaptTo(Node.class);
            if (node == null) {
                log.warn("Resource {} not backed by Node", (Object)resource);
                return;
            }
            log.debug("Checking out node {}", (Object)node.getPath());
            node.getSession().getWorkspace().getVersionManager().checkout(node.getPath());
            changes.add(Modification.onCheckout((String)resource.getPath()));
        }
    }
}

