/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Static;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.apache.sis.util.resources.Errors;

public final class MathFunctions
extends Static {
    public static final double SQRT_2 = 1.4142135623730951;
    public static final double LOG10_2 = 0.3010299956639812;
    public static final int MIN_NAN_ORDINAL = -2097152;
    public static final int MAX_NAN_ORDINAL = 0x1FFFFF;
    static final int POSITIVE_NAN = 2143289344;
    static final int NEGATIVE_NAN = -4194304;
    public static final int HIGHEST_SUPPORTED_PRIME_NUMBER = 65521;
    static final int PRIMES_LENGTH_15_BITS = 3512;
    static final int PRIMES_LENGTH_16_BITS = 6542;
    private static volatile short[] primes = new short[]{2, 3};

    private MathFunctions() {
    }

    public static double average(long x, long y) {
        long xor = x ^ y;
        double c = (x & y) + (xor >> 1);
        if ((xor & 1L) != 0L) {
            c += 0.5;
        }
        return c;
    }

    public static double truncate(double value) {
        return (Double.doubleToRawLongBits(value) & Long.MIN_VALUE) == 0L ? Math.floor(value) : Math.ceil(value);
    }

    public static double magnitude(double ... vector) {
        double v3;
        double v2;
        double v1;
        int i = vector.length;
        do {
            if (i != 0) continue;
            return 0.0;
        } while ((v1 = vector[--i]) == 0.0);
        do {
            if (i != 0) continue;
            return Math.abs(v1);
        } while ((v2 = vector[--i]) == 0.0);
        do {
            if (i != 0) continue;
            return Math.hypot(v1, v2);
        } while ((v3 = vector[--i]) == 0.0);
        DoubleDouble sum = DoubleDouble.product(v1, v1);
        sum = sum.add(DoubleDouble.product(v2, v2));
        sum = sum.add(DoubleDouble.product(v3, v3));
        while (i != 0) {
            double v = vector[--i];
            sum = sum.add(DoubleDouble.product(v, v));
        }
        return sum.sqrt().doubleValue();
    }

    public static int getExponent(double value) {
        long bits = Double.doubleToRawLongBits(value);
        int exponent = (int)(bits >>> 52 & 0x7FFL);
        if (exponent == 0) {
            exponent -= Long.numberOfLeadingZeros(bits & 0xFFFFFFFFFFFFFL) - 12;
        }
        return exponent - 1023;
    }

    public static long pow(long base, int exponent) {
        long result = 1L;
        if (exponent >= 1) {
            if ((exponent & 1) != 0) {
                result = base;
            }
            while ((exponent >>>= 1) != 0) {
                base = Math.multiplyExact(base, base);
                if ((exponent & 1) == 0) continue;
                result = Math.multiplyExact(result, base);
            }
        } else if (exponent < 0) {
            throw new ArithmeticException(Errors.format((short)117, "exponent", exponent));
        }
        return result;
    }

    public static double pow10(int x) {
        return DecimalFunctions.pow10(x);
    }

    public static double pow10(double x) {
        int ix = (int)x;
        if ((double)ix == x) {
            return DecimalFunctions.pow10(ix);
        }
        return Math.pow(10.0, x);
    }

    public static double asinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static double acosh(double x) {
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    public static double atanh(double x) {
        return 0.5 * Math.log1p(2.0 * x / (1.0 - x));
    }

    public static boolean isPositive(double value) {
        return (Double.doubleToRawLongBits(value) & Long.MIN_VALUE) == 0L && !Double.isNaN(value);
    }

    public static boolean isPositiveZero(double value) {
        return Double.doubleToRawLongBits(value) == 0L;
    }

    public static boolean isNegative(double value) {
        return (Double.doubleToRawLongBits(value) & Long.MIN_VALUE) != 0L && !Double.isNaN(value);
    }

    public static boolean isNegativeZero(double value) {
        return Double.doubleToRawLongBits(value) == Long.MIN_VALUE;
    }

    public static boolean isSameSign(double v1, double v2) {
        return !Double.isNaN(v1) && !Double.isNaN(v2) && ((Double.doubleToRawLongBits(v1) ^ Double.doubleToRawLongBits(v2)) & Long.MIN_VALUE) == 0L;
    }

    public static double xorSign(double value, double sign) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(value) ^ Double.doubleToRawLongBits(sign) & Long.MIN_VALUE);
    }

    public static boolean epsilonEqual(float v1, float v2, float \u03b5) {
        return Math.abs(v1 - v2) <= \u03b5 || Float.floatToIntBits(v1) == Float.floatToIntBits(v2);
    }

    public static boolean epsilonEqual(double v1, double v2, double \u03b5) {
        return Math.abs(v1 - v2) <= \u03b5 || Double.doubleToLongBits(v1) == Double.doubleToLongBits(v2);
    }

    public static float toNanFloat(int ordinal) throws IllegalArgumentException {
        ArgumentChecks.ensureBetween("ordinal", -2097152, 0x1FFFFF, ordinal);
        int bits = ordinal >= 0 ? ordinal : ~ordinal;
        bits = bits + 2143289344 | ordinal & Integer.MIN_VALUE;
        assert (Integer.compareUnsigned(bits, ordinal >= 0 ? 2143289344 : -4194304) >= 0) : ordinal;
        float value = Float.intBitsToFloat(bits);
        assert (Float.isNaN(value) && MathFunctions.toNanOrdinal(value) == ordinal) : ordinal;
        return value;
    }

    public static int toNanOrdinal(float value) throws IllegalArgumentException {
        Object[] obj;
        short resourceKey;
        int bits = Float.floatToRawIntBits(value);
        int ordinal = (bits & Integer.MAX_VALUE) - 2143289344;
        if (bits < 0) {
            ordinal ^= 0xFFFFFFFF;
        }
        if (ordinal >= -2097152 && ordinal <= 0x1FFFFF) {
            return ordinal;
        }
        if (Float.isNaN(value)) {
            resourceKey = 60;
            obj = Integer.toHexString(bits);
        } else {
            resourceKey = 59;
            obj = new Object[]{"value", Float.valueOf(value)};
        }
        throw new IllegalArgumentException(Errors.format(resourceKey, obj));
    }

    public static double quadrupleToDouble(long l0, long l1) {
        long sig = l0 & Long.MIN_VALUE;
        long exp = (l0 & 0x7FFF000000000000L) >> 48;
        l0 &= 0xFFFFFFFFFFFFL;
        if (exp == 0L) {
            return Double.longBitsToDouble(sig);
        }
        if (exp == 32767L) {
            if (l0 == 0L && l1 == 0L) {
                return Double.longBitsToDouble(sig | 0x7FF0000000000000L);
            }
            return Double.NaN;
        }
        if ((exp -= 15360L) < 0L) {
            return Double.NEGATIVE_INFINITY;
        }
        if (exp > 2046L) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.longBitsToDouble(sig | exp << 52 | l0 << 4 | l1 >>> 60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int primeNumberAt(int index) throws IndexOutOfBoundsException {
        Objects.checkIndex(index, 6542);
        short[] primes = MathFunctions.primes;
        if (index < primes.length) return Short.toUnsignedInt(primes[index]);
        Class<MathFunctions> clazz = MathFunctions.class;
        synchronized (MathFunctions.class) {
            primes = MathFunctions.primes;
            if (index < primes.length) return Short.toUnsignedInt(primes[index]);
            int i = primes.length;
            int n = Short.toUnsignedInt(primes[i - 1]);
            primes = Arrays.copyOf(primes, Math.min((index | 0xF) + 1, 6542));
            block3: while (true) {
                int prime;
                int stopAt = (int)Math.sqrt(n += 2);
                int j = 0;
                do {
                    if (n % (prime = Short.toUnsignedInt(primes[++j])) == 0) continue block3;
                } while (prime <= stopAt);
                primes[i] = (short)n;
                if (++i >= primes.length) break;
            }
            MathFunctions.primes = primes;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Short.toUnsignedInt(primes[index]);
        }
    }

    public static int nextPrimeNumber(int number) throws IllegalArgumentException {
        int i;
        ArgumentChecks.ensureBetween("number", 2, 65521, number);
        short[] primes = MathFunctions.primes;
        int lower = 0;
        int upper = Math.min(3512, primes.length);
        if (number > Short.MAX_VALUE) {
            lower = upper;
            upper = primes.length;
        }
        if ((i = Arrays.binarySearch(primes, lower, upper, (short)number)) < 0 && (i ^= 0xFFFFFFFF) >= primes.length) {
            int p;
            while ((p = MathFunctions.primeNumberAt(i++)) < number) {
            }
            return p;
        }
        return Short.toUnsignedInt(primes[i]);
    }

    public static int[] divisors(int number) {
        int d2;
        int d1;
        int p;
        if (number == 0) {
            return ArraysExt.EMPTY_INT;
        }
        number = Math.abs(number);
        int[] divisors = new int[16];
        divisors[0] = 1;
        int count = 1;
        int i = 0;
        while (Math.multiplyFull(p = MathFunctions.primeNumberAt(i), p) <= (long)number) {
            if (number % p == 0) {
                if (count == divisors.length) {
                    divisors = Arrays.copyOf(divisors, count * 2);
                }
                divisors[count++] = p;
            }
            ++i;
        }
        int source = count;
        if (count * 2 > divisors.length) {
            divisors = Arrays.copyOf(divisors, count * 2);
        }
        if ((d1 = divisors[--source]) != (d2 = number / d1)) {
            divisors[count++] = d2;
        }
        while (--source >= 0) {
            divisors[count++] = number / divisors[source];
        }
        for (int i2 = 1; i2 < count; ++i2) {
            long m;
            d1 = divisors[i2];
            for (int j = i2; j < count && (m = Math.multiplyFull(d1, divisors[j])) <= (long)number; ++j) {
                int p2;
                d2 = (int)m;
                if (number % d2 != 0 || (p2 = Arrays.binarySearch(divisors, j, count, d2)) >= 0) continue;
                p2 ^= 0xFFFFFFFF;
                if (count == divisors.length) {
                    divisors = Arrays.copyOf(divisors, count * 2);
                }
                System.arraycopy(divisors, p2, divisors, p2 + 1, count - p2);
                divisors[p2] = d2;
                ++count;
            }
        }
        divisors = ArraysExt.resize(divisors, count);
        assert (ArraysExt.isSorted(divisors, true));
        return divisors;
    }

    public static int[] commonDivisors(int ... numbers) {
        if (numbers.length == 0) {
            return ArraysExt.EMPTY_INT;
        }
        int minValue = Integer.MAX_VALUE;
        for (int i = 0; i < numbers.length; ++i) {
            int n = Math.abs(numbers[i]);
            if (n > minValue) continue;
            minValue = n;
        }
        int[] divisors = MathFunctions.divisors(minValue);
        int count = divisors.length;
        for (int i = 0; i < numbers.length; ++i) {
            int n = Math.abs(numbers[i]);
            if (n == minValue) continue;
            int j = count;
            while (--j > 0) {
                if (n % divisors[j] == 0) continue;
                System.arraycopy(divisors, j + 1, divisors, j, --count - j);
            }
        }
        return ArraysExt.resize(divisors, count);
    }

    public static double[] polynomialRoots(double ... coefficients) {
        int upper = coefficients.length;
        block7: while (upper > 0) {
            double c;
            double a;
            if ((a = coefficients[--upper]) == 0.0) continue;
            int lower = 0;
            while ((c = coefficients[lower]) == 0.0) {
                ++lower;
            }
            switch (upper - lower) {
                case 0: {
                    break block7;
                }
                case 1: {
                    double x = -c / a;
                    if (Double.isNaN(x)) break block7;
                    return new double[]{x};
                }
                case 2: {
                    double[] dArray;
                    double b = coefficients[lower + 1];
                    double q = -0.5 * (b + Math.copySign(Math.sqrt(b * b - 4.0 * a * c), b));
                    double x1 = q / a;
                    double x2 = c / q;
                    if (Double.isNaN(x1) && Double.isNaN(x2)) break block7;
                    if (x1 != x2) {
                        double[] dArray2 = new double[2];
                        dArray2[0] = x1;
                        dArray = dArray2;
                        dArray2[1] = x2;
                    } else {
                        double[] dArray3 = new double[1];
                        dArray = dArray3;
                        dArray3[0] = x1;
                    }
                    return dArray;
                }
                case 3: {
                    return MathFunctions.refineRoots(coefficients, MathFunctions.solveCubic(coefficients[lower + 2] / a, coefficients[lower + 1] / a, c / a, false));
                }
                case 4: {
                    double \u03b3;
                    double \u03b2;
                    double \u03b1;
                    double s;
                    int i;
                    double d = c / a;
                    c = coefficients[lower + 1] / a;
                    double b = coefficients[lower + 2] / a;
                    a = coefficients[lower + 3] / a;
                    double a2 = a * a;
                    double p = Math.fma(-0.375, a2, b);
                    double q = Math.fma(0.125 * a2 - 0.5 * b, a, c);
                    double r = Math.fma(-0.01171875, a2, 0.0625 * b) * a2 + Math.fma(-0.25 * a, c, d);
                    double[] roots = MathFunctions.solveCubic(-2.0 * p, p * p - 4.0 * r, q * q, true);
                    if (roots.length != 4) break block7;
                    for (i = 0; i < 3; ++i) {
                        roots[i] = Math.sqrt(-roots[i]);
                    }
                    if (MathFunctions.isPositive(q)) {
                        for (i = 0; i < 3; ++i) {
                            roots[i] = -roots[i];
                        }
                    }
                    if (Double.isNaN(s = (\u03b1 = roots[0]) + (\u03b2 = roots[1]) + (\u03b3 = roots[2]))) break block7;
                    roots[0] = s / 2.0 - (a /= 4.0);
                    roots[1] = (\u03b1 - \u03b2 - \u03b3) / 2.0 - a;
                    roots[2] = (-\u03b1 + \u03b2 - \u03b3) / 2.0 - a;
                    roots[3] = (-\u03b1 - \u03b2 + \u03b3) / 2.0 - a;
                    return MathFunctions.refineRoots(coefficients, MathFunctions.removeDuplicated(roots));
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return ArraysExt.EMPTY_DOUBLE;
    }

    private static double[] solveCubic(double a, double b, double c, boolean quartic) {
        double x;
        double Q = (a * a - 3.0 * b) / 9.0;
        double R = (a * (a * a - 4.5 * b) + 13.5 * c) / 27.0;
        double Q3 = Q * Q * Q;
        double R2 = R * R;
        a /= -3.0;
        if (R2 < Q3) {
            b = Math.acos(R / Math.sqrt(Q3)) / 3.0;
            c = -2.0 * Math.sqrt(Q);
            double[] roots = new double[quartic ? 4 : 3];
            roots[2] = Math.fma(c, Math.cos(b - 2.0943951023931953), a);
            roots[1] = Math.fma(c, Math.cos(b + 2.0943951023931953), a);
            roots[0] = Math.fma(c, Math.cos(b), a);
            if (!quartic) {
                roots = MathFunctions.removeDuplicated(roots);
            }
            return roots;
        }
        if (!quartic && !Double.isNaN(x = ((b = -Math.copySign(Math.cbrt(Math.abs(R) + Math.sqrt(R2 - Q3)), R)) == 0.0 ? 0.0 : b + Q / b) + a)) {
            return new double[]{x};
        }
        return ArraysExt.EMPTY_DOUBLE;
    }

    private static double[] removeDuplicated(double[] roots) {
        int i = 1;
        block0: while (i < roots.length) {
            int j = i;
            while (--j >= 0) {
                if (roots[j] != roots[i]) continue;
                roots = ArraysExt.remove(roots, i, 1);
                continue block0;
            }
            ++i;
        }
        return roots;
    }

    private static double[] refineRoots(double[] coefficients, double[] roots) {
        block0: for (int i = 0; i < roots.length; ++i) {
            double dy;
            double y;
            double dx;
            double ymin = Double.POSITIVE_INFINITY;
            double x = roots[i];
            do {
                double px = 1.0;
                dy = 0.0;
                y = coefficients[0];
                double ey = 0.0;
                double edy = 0.0;
                for (int j = 1; j < coefficients.length; ++j) {
                    double c = coefficients[j];
                    double s = c * (px * (double)i) + edy;
                    edy = s + (dy - (dy += s));
                    s = c * (px *= x) + ey;
                    ey = s + (y - (y += s));
                }
                if (!(ymin > (ymin = Math.abs(y)))) continue block0;
                roots[i] = x;
            } while (x != (x -= (dx = y / dy)) && Double.isFinite(x));
        }
        return roots;
    }
}

