/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.OperatorCentroid2D;
import com.esri.core.geometry.OperatorImportFromWkb;
import com.esri.core.geometry.OperatorImportFromWkt;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.Segment;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.sis.geometry.wrapper.Capability;
import org.apache.sis.geometry.wrapper.Dimensions;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryType;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.geometry.wrapper.esri.Wrapper;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.internal.shared.CollectionsExt;
import org.apache.sis.util.resources.Errors;

public final class Factory
extends Geometries<Geometry> {
    private static final long serialVersionUID = 7832006589071845318L;
    public static final Factory INSTANCE = new Factory();

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private Factory() {
        super(GeometryLibrary.ESRI, Geometry.class, Point.class);
    }

    @Override
    public Class<?> getGeometryClass(GeometryType type) {
        switch (type) {
            default: {
                return Geometry.class;
            }
            case POINT: {
                return Point.class;
            }
            case MULTIPOINT: {
                return MultiPoint.class;
            }
            case MULTILINESTRING: 
            case LINESTRING: {
                return Polyline.class;
            }
            case MULTIPOLYGON: 
            case POLYGON: 
        }
        return Polygon.class;
    }

    @Override
    public GeometryType getGeometryType(Class<?> type) {
        Class<?> component = type.getComponentType();
        if (component != null) {
            type = component;
        }
        if (Point.class.isAssignableFrom(type)) {
            return component != null ? GeometryType.MULTIPOINT : GeometryType.POINT;
        }
        if (Polygon.class.isAssignableFrom(type)) {
            return component != null ? GeometryType.MULTIPOLYGON : GeometryType.POLYGON;
        }
        if (Polyline.class.isAssignableFrom(type)) {
            return component != null ? GeometryType.MULTILINESTRING : GeometryType.LINESTRING;
        }
        if (MultiPoint.class.isAssignableFrom(type)) {
            return GeometryType.MULTIPOINT;
        }
        return GeometryType.GEOMETRY;
    }

    @Override
    public Object getGeometry(GeometryWrapper wrapper) {
        if (wrapper instanceof Wrapper) {
            return ((Wrapper)wrapper).implementation();
        }
        return super.getGeometry(wrapper);
    }

    @Override
    public GeometryWrapper castOrWrap(Object geometry) {
        if (geometry == null || geometry instanceof Wrapper) {
            return (Wrapper)geometry;
        }
        return new Wrapper((Geometry)geometry);
    }

    @Override
    public boolean supports(Capability feature) {
        return feature != Capability.SINGLE_PRECISION;
    }

    @Override
    protected GeometryWrapper createWrapper(Geometry geometry) {
        return new Wrapper(geometry);
    }

    @Override
    public Object createPoint(double x, double y) {
        return new Point(x, y);
    }

    @Override
    public Object createPoint(double x, double y, double z) {
        return new Point(x, y, z);
    }

    @Override
    public Object createPoint(boolean isFloat, Dimensions dimensions, DoubleBuffer coordinates) {
        Point point = new Point(coordinates.get(), coordinates.get());
        if (dimensions.hasZ) {
            point.setM(coordinates.get());
        }
        if (dimensions.hasM) {
            point.setM(coordinates.get());
        }
        return point;
    }

    @Override
    public Geometry createMultiPoint(boolean isFloat, Dimensions dimensions, DoubleBuffer coordinates) {
        boolean is2D = dimensions == Dimensions.XY;
        MultiPoint points = new MultiPoint();
        while (coordinates.hasRemaining()) {
            double x = coordinates.get();
            double y = coordinates.get();
            if (is2D) {
                points.add(x, y);
                continue;
            }
            Point point = new Point(x, y);
            if (dimensions.hasZ) {
                point.setZ(coordinates.get());
            }
            if (dimensions.hasM) {
                point.setM(coordinates.get());
            }
            points.add(point);
        }
        return points;
    }

    @Override
    public Geometry createPolyline(boolean polygon, boolean isFloat, Dimensions dimensions, DoubleBuffer ... coordinates) {
        boolean is2D = dimensions == Dimensions.XY;
        boolean lineTo = false;
        Polyline path = new Polyline();
        for (DoubleBuffer v : coordinates) {
            if (v == null) continue;
            while (v.hasRemaining()) {
                double x = v.get();
                double y = v.get();
                if (Double.isNaN(x) || Double.isNaN(y)) {
                    v.position(v.position() + (dimensions.count - 2));
                    lineTo = false;
                    continue;
                }
                if (is2D) {
                    if (lineTo) {
                        path.lineTo(x, y);
                        continue;
                    }
                    path.startPath(x, y);
                    lineTo = true;
                    continue;
                }
                Point point = new Point(x, y);
                if (dimensions.hasZ) {
                    point.setZ(v.get());
                }
                if (dimensions.hasM) {
                    point.setM(v.get());
                }
                if (lineTo) {
                    path.lineTo(point);
                    continue;
                }
                path.startPath(point);
                lineTo = true;
            }
        }
        if (polygon) {
            Polygon p = new Polygon();
            p.add((MultiPath)path, false);
            return p;
        }
        return path;
    }

    @Override
    public GeometryWrapper createMultiPolygon(Object[] geometries) {
        Polygon polygon = new Polygon();
        for (Object geometry : geometries) {
            polygon.add((MultiPath)Factory.implementation(geometry), false);
        }
        return new Wrapper((Geometry)polygon);
    }

    @Override
    public GeometryWrapper createFromComponents(GeometryType type, Object components) {
        Geometry geometry;
        block16: {
            List<Object> data = components instanceof Collection ? (List<Object>)components : Arrays.asList((Object[])components);
            geometry = (Geometry)CollectionsExt.singletonOrNull(data);
            if (geometry == null) {
                Polygon path;
                boolean isPolygon = false;
                switch (type) {
                    default: {
                        throw new IllegalArgumentException(Errors.format((short)191, (Object)((Object)type)));
                    }
                    case GEOMETRY: {
                        return this.createFromComponents(components);
                    }
                    case MULTILINESTRING: 
                    case LINESTRING: {
                        break;
                    }
                    case MULTIPOLYGON: 
                    case POLYGON: {
                        isPolygon = true;
                        break;
                    }
                    case GEOMETRYCOLLECTION: {
                        Object component;
                        Iterator iterator = data.iterator();
                        while (iterator.hasNext() && (isPolygon = ((Geometry)(component = iterator.next())).getType() == Geometry.Type.Polygon)) {
                        }
                        break;
                    }
                    case POINT: 
                    case MULTIPOINT: {
                        MultiPoint points = new MultiPoint();
                        for (Object e : data) {
                            points.add((Point)e);
                        }
                        geometry = points;
                        if (type == GeometryType.POINT) {
                            geometry = new Point(OperatorCentroid2D.local().execute(geometry, null));
                        }
                        break block16;
                    }
                }
                Object object = path = isPolygon ? new Polygon() : new Polyline();
                if (type.isCollection) {
                    for (Object e : data) {
                        path.add((MultiPath)e, false);
                    }
                } else {
                    Iterator it = data.iterator();
                    if (it.hasNext()) {
                        Line line = new Line();
                        line.setEnd((Point)it.next());
                        while (it.hasNext()) {
                            line.setStartXY(line.getEndX(), line.getEndY());
                            line.setEnd((Point)it.next());
                            path.addSegment((Segment)line, false);
                        }
                    }
                }
                geometry = path;
            }
        }
        return new Wrapper(geometry);
    }

    @Override
    public GeometryWrapper parseWKT(String wkt) {
        return new Wrapper(OperatorImportFromWkt.local().execute(0, Geometry.Type.Unknown, wkt, null));
    }

    @Override
    public GeometryWrapper parseWKB(ByteBuffer data) {
        if (data.position() != 0) {
            data = data.slice();
        }
        return new Wrapper(OperatorImportFromWkb.local().execute(0, Geometry.Type.Unknown, data, null));
    }
}

