/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage;

import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.util.Arrays;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.ImageRenderer;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.coverage.internal.shared.SampleDimensions;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.image.ImageCombiner;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.Interpolation;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.shared.Numerics;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;

public class CoverageCombiner {
    private static final int BIDIMENSIONAL = 2;
    private final ImageProcessor processor;
    private final GridCoverage destination;
    private final int xdim;
    private final int ydim;
    private final boolean isConverted;

    public CoverageCombiner(GridCoverage destination) {
        this.destination = destination.forConvertedValues(true);
        this.isConverted = this.destination == destination;
        int[] dim = destination.getGridGeometry().getExtent().getLargestDimensions(2);
        this.xdim = dim[0];
        this.ydim = dim[1];
        this.processor = new ImageProcessor();
    }

    public Interpolation getInterpolation() {
        return this.processor.getInterpolation();
    }

    public void setInterpolation(Interpolation method) {
        this.processor.setInterpolation(method);
    }

    private static GridGeometry getImageGeometry(RenderedImage image, GridCoverage coverage, GridExtent slice) {
        Object value = image.getProperty("org.apache.sis.GridGeometry");
        if (value instanceof GridGeometry) {
            return (GridGeometry)value;
        }
        return new ImageRenderer(coverage, slice).getImageGeometry(2);
    }

    private static MathTransform1D[] createUnitConverters(Unit<?>[] sources, Unit<?>[] targets) throws IncommensurableException {
        Object[] converters = null;
        int n = Math.min(sources.length, targets.length);
        for (int i = 0; i < n; ++i) {
            MathTransform1D c;
            Unit<?> source = sources[i];
            Unit<?> target = targets[i];
            if (source == null || target == null || (c = MathTransforms.convert((UnitConverter)source.getConverterToAny(target))).isIdentity()) continue;
            if (converters == null) {
                converters = new MathTransform1D[n];
                Arrays.fill(converters, MathTransforms.identity((int)1));
            }
            converters[i] = c;
        }
        return converters;
    }

    public boolean acceptAll(GridCoverage ... sources) throws TransformException, IncommensurableException {
        sources = (GridCoverage[])sources.clone();
        GridGeometry targetGG = this.destination.getGridGeometry();
        GridExtent targetEx = targetGG.getExtent();
        int dimension = targetEx.getDimension();
        long[] minIndices = new long[dimension];
        Arrays.fill(minIndices, Long.MAX_VALUE);
        long[] maxIndices = new long[dimension];
        Arrays.fill(maxIndices, Long.MIN_VALUE);
        MathTransform[] toSourceSliceCorner = new MathTransform[sources.length];
        MathTransform[] toSourceSliceCenter = new MathTransform[sources.length];
        MathTransform1D[][] unitConverters = new MathTransform1D[sources.length][];
        NumberRange[][] sourceRanges = new NumberRange[sources.length][];
        Unit<?>[] destinationUnits = SampleDimensions.units(this.destination);
        int numSources = 0;
        block0: for (int j = 0; j < sources.length; ++j) {
            int i;
            GridCoverage source = sources[j];
            ArgumentChecks.ensureNonNullElement((String)"sources", (int)j, (Object)source);
            source = source.forConvertedValues(true);
            GridGeometry sourceGG = source.getGridGeometry();
            GridExtent sourceEx = sourceGG.getExtent();
            MathTransform toSource = targetGG.createTransformTo(sourceGG, PixelInCell.CELL_CORNER);
            GeneralEnvelope env = sourceEx.toEnvelope(toSource.inverse());
            long[] min = new long[dimension];
            long[] max = new long[dimension];
            for (i = 0; i < dimension; ++i) {
                min[i] = Math.max(targetEx.getLow(i), Math.round(env.getMinimum(i)));
                max[i] = Math.min(targetEx.getHigh(i), Math.round(env.getMaximum(i) - 1.0));
                if (min[i] > max[i]) continue block0;
            }
            for (i = 0; i < dimension; ++i) {
                minIndices[i] = Math.min(minIndices[i], min[i]);
                maxIndices[i] = Math.max(maxIndices[i], max[i]);
            }
            toSourceSliceCenter[numSources] = targetGG.createTransformTo(sourceGG, PixelInCell.CELL_CENTER);
            toSourceSliceCorner[numSources] = toSource;
            sources[numSources] = source;
            unitConverters[numSources] = CoverageCombiner.createUnitConverters(SampleDimensions.units(source), destinationUnits);
            sourceRanges[numSources] = SampleDimensions.ranges(source);
            ++numSources;
        }
        Arrays.fill(sources, numSources, sources.length, null);
        if (numSources == 0) {
            return true;
        }
        long[] minSliceIndices = (long[])minIndices.clone();
        long[] maxSliceIndices = (long[])maxIndices.clone();
        double[] centerIndices = targetEx.getPointOfInterest(PixelInCell.CELL_CENTER);
        Dimension margin = this.processor.getInterpolation().getSupportSize();
        margin.width = (margin.width + 1 >> 1) + 1;
        margin.height = (margin.height + 1 >> 1) + 1;
        boolean success = true;
        block3: while (true) {
            GridExtent targetSliceExtent;
            RenderedImage targetSlice;
            if ((targetSlice = this.destination.render(targetSliceExtent = new GridExtent(null, minSliceIndices, maxSliceIndices, true))) instanceof WritableRenderedImage) {
                ImageCombiner combiner = new ImageCombiner((WritableRenderedImage)targetSlice, this.processor);
                for (int j = 0; j < numSources; ++j) {
                    GridCoverage source = sources[j];
                    int srcDim = source.getGridGeometry().getDimension();
                    long[] minSourceIndices = new long[srcDim];
                    long[] maxSourceIndices = new long[srcDim];
                    double[] centerSourceIndices = new double[srcDim];
                    toSourceSliceCenter[j].transform(centerIndices, 0, centerSourceIndices, 0, 1);
                    GeneralEnvelope env = targetSliceExtent.toEnvelope(toSourceSliceCorner[j]);
                    for (int i = 0; i < srcDim; ++i) {
                        if (i == this.xdim || i == this.ydim) {
                            int m = i == this.xdim ? margin.width : margin.height;
                            minSourceIndices[i] = Numerics.saturatingSubtract((long)Math.round(env.getMinimum(i)), (long)m);
                            maxSourceIndices[i] = Numerics.saturatingAdd((long)Math.round(env.getMaximum(i)), (long)((long)m - 1L));
                            continue;
                        }
                        minSourceIndices[i] = Math.round(centerSourceIndices[i]);
                        maxSourceIndices[i] = minSourceIndices[i];
                    }
                    GridExtent sourceSliceExtent = new GridExtent(null, minSourceIndices, maxSourceIndices, true);
                    RenderedImage sourceSlice = source.render(sourceSliceExtent);
                    MathTransform1D[] converters = unitConverters[j];
                    if (converters != null) {
                        sourceSlice = this.processor.convert(sourceSlice, sourceRanges[j], converters, combiner.getBandType());
                    }
                    MathTransform toSource = CoverageCombiner.getImageGeometry(targetSlice, this.destination, targetSliceExtent).createTransformTo(CoverageCombiner.getImageGeometry(sourceSlice, source, sourceSliceExtent), PixelInCell.CELL_CENTER);
                    combiner.resample(sourceSlice, null, toSource);
                }
            } else {
                success = false;
            }
            for (int i = 0; i < dimension; ++i) {
                boolean done;
                if (i == this.xdim || i == this.ydim) continue;
                long index = minSliceIndices[i];
                boolean bl = done = index++ <= maxIndices[i];
                if (!done) {
                    index = minIndices[i];
                }
                maxSliceIndices[i] = minSliceIndices[i] = index;
                if (done) continue block3;
            }
            break;
        }
        return success;
    }

    public GridCoverage result() {
        return this.destination.forConvertedValues(this.isConverted);
    }
}

