/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gpx;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.sis.io.TableAppender;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.metadata.iso.identification.DefaultKeywords;
import org.apache.sis.metadata.simple.SimpleMetadata;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.storage.gpx.Bounds;
import org.apache.sis.storage.gpx.Copyright;
import org.apache.sis.storage.gpx.Link;
import org.apache.sis.storage.gpx.Person;
import org.apache.sis.storage.gpx.Store;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.constraint.LegalConstraints;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Keywords;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

public final class Metadata
extends SimpleMetadata {
    Store store;
    public String creator;
    @XmlElement(name="name")
    public String name;
    @XmlElement(name="desc")
    public String description;
    @XmlElement(name="author")
    public Person author;
    @XmlElement(name="copyright")
    public Copyright copyright;
    @XmlElement(name="link")
    public List<Link> links;
    @XmlElement(name="time")
    public Date time;
    @XmlList
    @XmlElement(name="keywords")
    public List<String> keywords;
    @XmlElement(name="bounds")
    public Bounds bounds;
    private Format format;

    public Metadata() {
    }

    Metadata(org.opengis.metadata.Metadata md, Locale locale) {
        for (Identification id : md.getIdentificationInfo()) {
            Citation ci = id.getCitation();
            if (ci != null) {
                if (this.name == null) {
                    this.name = Types.toString((InternationalString)ci.getTitle(), (Locale)locale);
                }
                if (this.time == null) {
                    for (CitationDate d : ci.getDates()) {
                        this.time = d.getDate();
                        if (this.time == null) continue;
                        break;
                    }
                }
                if (ci instanceof DefaultCitation) {
                    for (ResponsibleParty r : ((DefaultCitation)ci).getOnlineResources()) {
                        this.links = Metadata.addIfNonNull(this.links, Link.castOrCopy((OnlineResource)r, locale));
                    }
                }
            }
            if (this.description == null) {
                this.description = Types.toString((InternationalString)id.getAbstract(), (Locale)locale);
            }
            for (ResponsibleParty r : id.getPointOfContacts()) {
                Person p = Person.castOrCopy(r, locale);
                if (p == null) continue;
                if (p.isCreator) {
                    if (this.creator != null) continue;
                    this.creator = p.name;
                    continue;
                }
                if (this.author != null) continue;
                this.author = p;
            }
            if (this.copyright == null) {
                for (Constraints c : id.getResourceConstraints()) {
                    if (!(c instanceof LegalConstraints)) continue;
                    this.copyright = Copyright.castOrCopy((LegalConstraints)c, locale);
                    if (this.copyright == null) continue;
                    break;
                }
            }
            for (Keywords k : id.getDescriptiveKeywords()) {
                for (InternationalString word : k.getKeywords()) {
                    this.keywords = Metadata.addIfNonNull(this.keywords, Types.toString((InternationalString)word, (Locale)locale));
                }
            }
            if (this.bounds != null) continue;
            this.bounds = Bounds.castOrCopy(Extents.getGeographicBoundingBox((org.opengis.metadata.Metadata)md));
        }
    }

    public static Metadata castOrCopy(org.opengis.metadata.Metadata md, Locale locale) {
        return md == null || md instanceof Metadata ? (Metadata)md : new Metadata(md, locale);
    }

    public InternationalString getTitle() {
        return this.name != null ? new SimpleInternationalString(this.name) : super.getTitle();
    }

    public InternationalString getAbstract() {
        return this.description != null ? new SimpleInternationalString(this.description) : super.getAbstract();
    }

    public Collection<Keywords> getDescriptiveKeywords() {
        if (this.keywords != null) {
            return Collections.singletonList(new DefaultKeywords((CharSequence[])this.keywords.toArray(String[]::new)));
        }
        return Collections.emptyList();
    }

    public Collection<ResponsibleParty> getPointOfContacts() {
        if (this.creator != null) {
            Person p = new Person(this.creator);
            return this.author != null ? UnmodifiableArrayList.wrap((Object[])new ResponsibleParty[]{p, this.author}) : Collections.singletonList(this.author);
        }
        return this.author != null ? Collections.singletonList(this.author) : Collections.emptyList();
    }

    public Collection<Constraints> getResourceConstraints() {
        return this.copyright != null ? Collections.singletonList(this.copyright) : Collections.emptyList();
    }

    public Collection<Extent> getExtents() {
        return this.bounds != null ? Collections.singletonList(this.bounds) : Collections.emptyList();
    }

    public Collection<ReferenceSystem> getReferenceSystemInfo() {
        return Collections.singletonList(CommonCRS.WGS84.geographic());
    }

    public Collection<CitationDate> getDates() {
        if (this.time != null) {
            return Collections.singletonList(new DefaultCitationDate(this.time, DateType.CREATION));
        }
        return Collections.emptyList();
    }

    public Collection<ContentInformation> getContentInfo() {
        Store store = this.store;
        return store != null ? store.types.metadata : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Format> getResourceFormats() {
        Store store = this.store;
        if (store != null) {
            Format f;
            Store store2 = store;
            synchronized (store2) {
                f = this.format;
                if (f == null) {
                    this.format = f = store.getFormat();
                }
            }
            return Collections.singletonList(f);
        }
        return Collections.emptyList();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Metadata) {
            Metadata that = (Metadata)((Object)obj);
            return Objects.equals(this.creator, that.creator) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.author, that.author) && Objects.equals(this.copyright, that.copyright) && Objects.equals(this.links, that.links) && Objects.equals(this.time, that.time) && Objects.equals(this.keywords, that.keywords) && Objects.equals((Object)this.bounds, (Object)that.bounds);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.creator, this.name, this.description, this.author, this.copyright, this.links, this.time, this.keywords, this.bounds});
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("GPX metadata").append(System.lineSeparator());
        TableAppender table = new TableAppender((Appendable)buffer);
        table.setMultiLinesCells(true);
        table.appendHorizontalSeparator();
        Metadata.append(table, "Creator", this.creator);
        Metadata.append(table, "Name", this.name);
        Metadata.append(table, "Description", this.description);
        Metadata.append(table, "Author", this.author);
        Metadata.append(table, "Copyright", this.copyright);
        Metadata.append(table, "Link(s)", this.links, System.lineSeparator());
        Metadata.append(table, "Time", this.time != null ? this.time.toInstant() : null);
        Metadata.append(table, "Keywords", this.keywords, " ");
        Metadata.append(table, "Bounds", (Object)this.bounds);
        table.appendHorizontalSeparator();
        try {
            table.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer.toString();
    }

    private static void append(TableAppender table, String label, Object value) {
        if (value != null) {
            table.append((CharSequence)label).append(':').nextColumn();
            table.append((CharSequence)value.toString()).nextLine();
        }
    }

    private static void append(TableAppender table, String label, List<?> values, String separator) {
        if (values != null && !values.isEmpty()) {
            table.append((CharSequence)label).append(':').nextColumn();
            int n = values.size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    table.append((CharSequence)separator);
                }
                table.append((CharSequence)values.get(i).toString());
            }
            table.nextLine();
        }
    }

    static <T> List<T> addIfNonNull(List<T> list, T element) {
        if (element != null) {
            if (list == null) {
                list = new ArrayList<T>(4);
            }
            list.add(element);
        }
        return list;
    }
}

