/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.reactor.impl;

import java.util.PriorityQueue;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.impl.CollectorImpl;
import org.apache.qpid.proton.reactor.Task;
import org.apache.qpid.proton.reactor.impl.TaskImpl;

public class Timer {
    private CollectorImpl collector;
    private PriorityQueue<TaskImpl> tasks = new PriorityQueue();

    public Timer(Collector collector) {
        this.collector = (CollectorImpl)collector;
    }

    Task schedule(long deadline) {
        TaskImpl task2 = new TaskImpl(deadline);
        this.tasks.add(task2);
        return task2;
    }

    long deadline() {
        this.flushCancelled();
        if (this.tasks.size() > 0) {
            Task task2 = this.tasks.peek();
            return task2.deadline();
        }
        return 0L;
    }

    private void flushCancelled() {
        TaskImpl task2;
        while (!this.tasks.isEmpty() && (task2 = this.tasks.peek()).isCancelled()) {
            this.tasks.poll();
        }
    }

    void tick(long now) {
        TaskImpl task2;
        while (!this.tasks.isEmpty() && now >= (task2 = this.tasks.peek()).deadline()) {
            this.tasks.poll();
            if (task2.isCancelled()) continue;
            this.collector.put(Event.Type.TIMER_TASK, task2);
        }
    }

    int tasks() {
        this.flushCancelled();
        return this.tasks.size();
    }
}

