/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.TransactionContext;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.ra.ActiveMQConnectionSupport;
import org.apache.activemq.ra.ActiveMQEndpointActivationKey;
import org.apache.activemq.ra.ActiveMQEndpointWorker;
import org.apache.activemq.ra.MessageActivationSpec;
import org.apache.activemq.ra.MessageResourceAdapter;
import org.apache.activemq.util.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQResourceAdapter
extends ActiveMQConnectionSupport
implements Serializable,
MessageResourceAdapter {
    private static final long serialVersionUID = 360805587169336959L;
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQResourceAdapter.class);
    private final transient HashMap<ActiveMQEndpointActivationKey, ActiveMQEndpointWorker> endpointWorkers = new HashMap();
    private transient BootstrapContext bootstrapContext;
    private String brokerXmlConfig;
    private transient BrokerService broker;
    private transient Thread brokerStartThread;
    private ActiveMQConnectionFactory connectionFactory;

    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        this.bootstrapContext = bootstrapContext;
        if (this.brokerXmlConfig != null && this.brokerXmlConfig.trim().length() > 0) {
            this.brokerStartThread = new Thread("Starting ActiveMQ Broker"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ActiveMQResourceAdapter.this.log.debug("original thread context classLoader: " + Thread.currentThread().getContextClassLoader());
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        ActiveMQResourceAdapter.this.log.debug("current (from getClass()) thread context classLoader: " + Thread.currentThread().getContextClassLoader());
                        ActiveMQResourceAdapter activeMQResourceAdapter = ActiveMQResourceAdapter.this;
                        synchronized (activeMQResourceAdapter) {
                            ActiveMQResourceAdapter.this.broker = BrokerFactory.createBroker(new URI(ActiveMQResourceAdapter.this.brokerXmlConfig));
                        }
                        ActiveMQResourceAdapter.this.broker.start();
                        if (ActiveMQResourceAdapter.this.getServerUrl() == null) {
                            ActiveMQResourceAdapter.this.setServerUrl("vm://" + ActiveMQResourceAdapter.this.broker.getBrokerName() + "?create=false");
                        }
                    }
                    catch (Throwable e) {
                        ActiveMQResourceAdapter.this.log.warn("Could not start up embeded ActiveMQ Broker '" + ActiveMQResourceAdapter.this.brokerXmlConfig + "': " + e.getMessage());
                        ActiveMQResourceAdapter.this.log.debug("Reason for: " + e.getMessage(), e);
                    }
                }
            };
            this.brokerStartThread.setDaemon(true);
            this.brokerStartThread.start();
            try {
                this.brokerStartThread.join(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public ActiveMQConnection makeConnection() throws JMSException {
        if (this.connectionFactory == null) {
            return this.makeConnection(this.getInfo());
        }
        return this.makeConnection(this.getInfo(), this.connectionFactory);
    }

    @Override
    public ActiveMQConnection makeConnection(MessageActivationSpec activationSpec) throws JMSException {
        ActiveMQConnectionFactory cf = this.getConnectionFactory();
        if (cf == null) {
            cf = this.createConnectionFactory(this.getInfo(), activationSpec);
        }
        String userName = this.defaultValue(activationSpec.getUserName(), this.getInfo().getUserName());
        String password = this.defaultValue(activationSpec.getPassword(), this.getInfo().getPassword());
        String clientId = activationSpec.getClientId();
        if (clientId != null) {
            cf.setClientID(clientId);
        } else if (activationSpec.isDurableSubscription()) {
            this.log.warn("No clientID specified for durable subscription: " + activationSpec);
        }
        ActiveMQConnection physicalConnection = (ActiveMQConnection)cf.createConnection(userName, password);
        RedeliveryPolicy redeliveryPolicy = activationSpec.redeliveryPolicy();
        if (redeliveryPolicy != null) {
            physicalConnection.setRedeliveryPolicy(redeliveryPolicy);
        }
        return physicalConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Serializable serializable = this.endpointWorkers;
        synchronized (serializable) {
            while (this.endpointWorkers.size() > 0) {
                ActiveMQEndpointActivationKey key = this.endpointWorkers.keySet().iterator().next();
                this.endpointDeactivation(key.getMessageEndpointFactory(), key.getActivationSpec());
            }
        }
        serializable = this;
        synchronized (serializable) {
            if (this.broker != null) {
                if (this.brokerStartThread.isAlive()) {
                    this.brokerStartThread.interrupt();
                }
                ServiceSupport.dispose(this.broker);
                this.broker = null;
            }
        }
        this.bootstrapContext = null;
    }

    @Override
    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec activationSpec) throws ResourceException {
        if (!this.equals(activationSpec.getResourceAdapter())) {
            throw new ResourceException("Activation spec not initialized with this ResourceAdapter instance (" + activationSpec.getResourceAdapter() + " != " + this + ")");
        }
        if (!(activationSpec instanceof MessageActivationSpec)) {
            throw new NotSupportedException("That type of ActivationSpec not supported: " + activationSpec.getClass());
        }
        ActiveMQEndpointActivationKey key = new ActiveMQEndpointActivationKey(endpointFactory, (MessageActivationSpec)activationSpec);
        if (this.endpointWorkers.containsKey(key)) {
            throw new IllegalStateException("Endpoint previously activated");
        }
        ActiveMQEndpointWorker worker = new ActiveMQEndpointWorker(this, key);
        this.endpointWorkers.put(key, worker);
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec activationSpec) {
        if (activationSpec instanceof MessageActivationSpec) {
            ActiveMQEndpointActivationKey key = new ActiveMQEndpointActivationKey(endpointFactory, (MessageActivationSpec)activationSpec);
            ActiveMQEndpointWorker worker = null;
            HashMap<ActiveMQEndpointActivationKey, ActiveMQEndpointWorker> hashMap = this.endpointWorkers;
            synchronized (hashMap) {
                worker = this.endpointWorkers.remove(key);
            }
            if (worker == null) {
                return;
            }
            try {
                worker.stop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecs) throws ResourceException {
        try {
            return new XAResource[]{new TransactionContext(){

                @Override
                public boolean isSameRM(XAResource xaresource) throws XAException {
                    ActiveMQConnection original = null;
                    try {
                        original = this.setConnection(this.newConnection());
                        boolean result = super.isSameRM(xaresource);
                        LOG.trace("{}.recover({})={}", new Object[]{this.getConnection(), xaresource, result});
                        boolean bl = result;
                        return bl;
                    }
                    catch (JMSException e) {
                        LOG.trace("isSameRM({}) failed", (Object)xaresource, (Object)e);
                        XAException xaException = new XAException(e.getMessage());
                        throw xaException;
                    }
                    finally {
                        this.closeConnection(original);
                    }
                }

                @Override
                protected String getResourceManagerId() throws JMSException {
                    ActiveMQConnection original = null;
                    try {
                        original = this.setConnection(this.newConnection());
                        String string = super.getResourceManagerId();
                        return string;
                    }
                    finally {
                        this.closeConnection(original);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void commit(Xid xid, boolean onePhase) throws XAException {
                    ActiveMQConnection original = null;
                    try {
                        this.setConnection(this.newConnection());
                        super.commit(xid, onePhase);
                        LOG.trace("{}.commit({},{})", (Object)this.getConnection(), (Object)xid);
                    }
                    catch (JMSException e) {
                        LOG.trace("{}.commit({},{}) failed", new Object[]{this.getConnection(), xid, onePhase, e});
                        this.throwXAException(e);
                    }
                    finally {
                        this.closeConnection(original);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void rollback(Xid xid) throws XAException {
                    ActiveMQConnection original = null;
                    try {
                        original = this.setConnection(this.newConnection());
                        super.rollback(xid);
                        LOG.trace("{}.rollback({})", (Object)this.getConnection(), (Object)xid);
                    }
                    catch (JMSException e) {
                        LOG.trace("{}.rollback({}) failed", new Object[]{this.getConnection(), xid, e});
                        this.throwXAException(e);
                    }
                    finally {
                        this.closeConnection(original);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Xid[] recover(int flags) throws XAException {
                    Xid[] result = new Xid[]{};
                    ActiveMQConnection original = null;
                    try {
                        original = this.setConnection(this.newConnection());
                        result = super.recover(flags);
                        LOG.trace("{}.recover({})={}", new Object[]{this.getConnection(), flags, result});
                    }
                    catch (JMSException e) {
                        LOG.trace("{}.recover({}) failed", new Object[]{this.getConnection(), flags, e});
                        this.throwXAException(e);
                    }
                    finally {
                        this.closeConnection(original);
                    }
                    return result;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void forget(Xid xid) throws XAException {
                    ActiveMQConnection original = null;
                    try {
                        original = this.setConnection(this.newConnection());
                        super.forget(xid);
                        LOG.trace("{}.forget({})", (Object)this.getConnection(), (Object)xid);
                    }
                    catch (JMSException e) {
                        LOG.trace("{}.forget({}) failed", new Object[]{this.getConnection(), xid, e});
                        this.throwXAException(e);
                    }
                    finally {
                        this.closeConnection(original);
                    }
                }

                private void throwXAException(JMSException e) throws XAException {
                    XAException xaException = new XAException(e.getMessage());
                    xaException.errorCode = -7;
                    throw xaException;
                }

                private ActiveMQConnection newConnection() throws JMSException {
                    ActiveMQConnection connection = ActiveMQResourceAdapter.this.makeConnection();
                    connection.start();
                    return connection;
                }

                private void closeConnection(ActiveMQConnection original) {
                    ActiveMQConnection connection = this.getConnection();
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (JMSException jMSException) {
                            // empty catch block
                        }
                    }
                    this.setConnection(original);
                }
            }};
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Override
    public String getBrokerXmlConfig() {
        return this.brokerXmlConfig;
    }

    public void setBrokerXmlConfig(String brokerXmlConfig) {
        this.brokerXmlConfig = brokerXmlConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageResourceAdapter)) {
            return false;
        }
        MessageResourceAdapter activeMQResourceAdapter = (MessageResourceAdapter)o;
        if (!this.getInfo().equals(activeMQResourceAdapter.getInfo())) {
            return false;
        }
        return !this.notEqual(this.brokerXmlConfig, activeMQResourceAdapter.getBrokerXmlConfig());
    }

    public int hashCode() {
        int result = this.getInfo().hashCode();
        if (this.brokerXmlConfig != null) {
            result ^= this.brokerXmlConfig.hashCode();
        }
        return result;
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ActiveMQConnectionFactory aConnectionFactory) {
        this.connectionFactory = aConnectionFactory;
    }
}

