/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.AbstractBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
public final class HashBiMap<K, V>
extends AbstractBiMap<K, V> {
    @GwtIncompatible(value="Not needed in emulated source")
    private static final long serialVersionUID = 0L;

    public static <K, V> HashBiMap<K, V> create() {
        return new HashBiMap<K, V>();
    }

    public static <K, V> HashBiMap<K, V> create(int expectedSize) {
        return new HashBiMap<K, V>(expectedSize);
    }

    public static <K, V> HashBiMap<K, V> create(Map<? extends K, ? extends V> map2) {
        HashBiMap<K, V> bimap = HashBiMap.create(map2.size());
        bimap.putAll((Map)map2);
        return bimap;
    }

    private HashBiMap() {
        super(new HashMap(), new HashMap());
    }

    private HashBiMap(int expectedSize) {
        super(Maps.newHashMapWithExpectedSize(expectedSize), Maps.newHashMapWithExpectedSize(expectedSize));
    }

    @Override
    public V put(@Nullable K key, @Nullable V value) {
        return super.put(key, value);
    }

    @Override
    public V forcePut(@Nullable K key, @Nullable V value) {
        return super.forcePut(key, value);
    }

    @GwtIncompatible(value="java.io.ObjectOutputStream")
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMap(this, stream);
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size2 = Serialization.readCount(stream);
        this.setDelegates(Maps.newHashMapWithExpectedSize(size2), Maps.newHashMapWithExpectedSize(size2));
        Serialization.populateMap(this, stream, size2);
    }
}

