/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.http4;

import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPoolCleaner {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionPoolCleaner.class);
    String name = "default";
    ClientConnectionManager connMgr;
    ScheduledExecutorService scheduler;
    private DynamicIntProperty connIdleEvictTimeMilliSeconds = DynamicPropertyFactory.getInstance().getIntProperty("default.nfhttpclient.connIdleEvictTimeMilliSeconds", 30000);
    volatile boolean enableConnectionPoolCleanerTask = false;
    long connectionCleanerTimerDelay = 10L;
    long connectionCleanerRepeatInterval = 30000L;
    private volatile ScheduledFuture<?> scheduledFuture;

    public ConnectionPoolCleaner(String name, ClientConnectionManager connMgr, ScheduledExecutorService scheduler) {
        this.name = name;
        this.connMgr = connMgr;
        this.scheduler = scheduler;
    }

    public DynamicIntProperty getConnIdleEvictTimeMilliSeconds() {
        return this.connIdleEvictTimeMilliSeconds;
    }

    public void setConnIdleEvictTimeMilliSeconds(DynamicIntProperty connIdleEvictTimeMilliSeconds) {
        this.connIdleEvictTimeMilliSeconds = connIdleEvictTimeMilliSeconds;
    }

    public boolean isEnableConnectionPoolCleanerTask() {
        return this.enableConnectionPoolCleanerTask;
    }

    public void setEnableConnectionPoolCleanerTask(boolean enableConnectionPoolCleanerTask) {
        this.enableConnectionPoolCleanerTask = enableConnectionPoolCleanerTask;
    }

    public long getConnectionCleanerTimerDelay() {
        return this.connectionCleanerTimerDelay;
    }

    public void setConnectionCleanerTimerDelay(long connectionCleanerTimerDelay) {
        this.connectionCleanerTimerDelay = connectionCleanerTimerDelay;
    }

    public long getConnectionCleanerRepeatInterval() {
        return this.connectionCleanerRepeatInterval;
    }

    public void setConnectionCleanerRepeatInterval(long connectionCleanerRepeatInterval) {
        this.connectionCleanerRepeatInterval = connectionCleanerRepeatInterval;
    }

    public void initTask() {
        if (this.enableConnectionPoolCleanerTask) {
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ConnectionPoolCleaner.this.enableConnectionPoolCleanerTask) {
                            logger.debug("Connection pool clean up started for client {}", (Object)ConnectionPoolCleaner.this.name);
                            ConnectionPoolCleaner.this.cleanupConnections();
                        } else if (ConnectionPoolCleaner.this.scheduledFuture != null) {
                            ConnectionPoolCleaner.this.scheduledFuture.cancel(true);
                        }
                    }
                    catch (Throwable e) {
                        logger.error("Exception in ConnectionPoolCleanerThread", e);
                    }
                }
            }, this.connectionCleanerTimerDelay, this.connectionCleanerRepeatInterval, TimeUnit.MILLISECONDS);
            logger.info("Initializing ConnectionPoolCleaner for NFHttpClient:" + this.name);
        }
    }

    void cleanupConnections() {
        this.connMgr.closeExpiredConnections();
        this.connMgr.closeIdleConnections((long)this.connIdleEvictTimeMilliSeconds.get(), TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.enableConnectionPoolCleanerTask = false;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectionPoolCleaner:" + this.name);
        sb.append(", connIdleEvictTimeMilliSeconds:" + this.connIdleEvictTimeMilliSeconds.get());
        sb.append(", connectionCleanerTimerDelay:" + this.connectionCleanerTimerDelay);
        sb.append(", connectionCleanerRepeatInterval:" + this.connectionCleanerRepeatInterval);
        return sb.toString();
    }
}

