/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.rest.common;

import com.netflix.config.DynamicPropertyFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.core.provider.producer.ProducerMeta;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;
import org.apache.servicecomb.provider.rest.common.RestSchema;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RestController;

@Component
public class RestProducers
implements BeanPostProcessor {
    private List<ProducerMeta> producerMetaList = new ArrayList<ProducerMeta>();
    private boolean scanRestController = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.provider.rest.scanRestController", true).get();

    public List<ProducerMeta> getProducerMetaList() {
        return this.producerMetaList;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.processProvider(beanName, bean);
        return bean;
    }

    protected void processProvider(String beanName, Object bean) {
        ProducerMeta producerMeta;
        Class beanCls = BeanUtils.getImplClassFromBean((Object)bean);
        if (beanCls == null) {
            return;
        }
        RestSchema restSchema = beanCls.getAnnotation(RestSchema.class);
        if (restSchema == null) {
            if (!this.scanRestController) {
                return;
            }
            RestController controller = beanCls.getAnnotation(RestController.class);
            if (controller == null) {
                return;
            }
            producerMeta = new ProducerMeta(beanCls.getName(), bean, beanCls);
        } else {
            producerMeta = new ProducerMeta(restSchema.schemaId(), bean, beanCls);
        }
        this.producerMetaList.add(producerMeta);
    }
}

