/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Locale;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.LoggersEndpoint;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBean;
import org.springframework.boot.logging.LogLevel;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.util.Assert;

public class LoggersEndpointMBean
extends EndpointMBean {
    public LoggersEndpointMBean(String beanName, Endpoint<?> endpoint, ObjectMapper objectMapper) {
        super(beanName, endpoint, objectMapper);
    }

    @ManagedAttribute(description="Get log levels for all known loggers")
    public Object getLoggers() {
        return this.convert(this.getEndpoint().invoke());
    }

    @ManagedOperation(description="Get log level for a given logger")
    public Object getLogger(String loggerName) {
        return this.convert(this.getEndpoint().invoke(loggerName));
    }

    @ManagedOperation(description="Set log level for a given logger")
    public void setLogLevel(String loggerName, String logLevel) {
        Assert.notNull((Object)logLevel, (String)"LogLevel must not be null");
        LogLevel level = LogLevel.valueOf((String)logLevel.toUpperCase(Locale.ENGLISH));
        this.getEndpoint().setLogLevel(loggerName, level);
    }

    public LoggersEndpoint getEndpoint() {
        return (LoggersEndpoint)super.getEndpoint();
    }
}

