/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.ssl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSLCustom {
    private static final Logger LOG = LoggerFactory.getLogger(SSLCustom.class);

    public static SSLCustom defaultSSLCustom() {
        SSLCustom custom = new SSLCustom(){

            @Override
            public char[] decode(char[] encrypted) {
                return encrypted;
            }

            @Override
            public String getFullPath(String filename) {
                return filename;
            }
        };
        return custom;
    }

    public static SSLCustom createSSLCustom(String name) {
        try {
            if (name != null && !name.isEmpty()) {
                return (SSLCustom)Class.forName(name).newInstance();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.warn("init SSLCustom class failed, name is " + name);
        }
        return SSLCustom.defaultSSLCustom();
    }

    public abstract char[] decode(char[] var1);

    public abstract String getFullPath(String var1);

    public String getHost() {
        return null;
    }
}

