/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.MXMLFileScope;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLComponentNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLModelNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.problems.MXMLUnresolvedTagProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.mxml.IMXMLDeclarationsNode;
import org.apache.royale.compiler.tree.mxml.IMXMLInstanceNode;

class MXMLDeclarationsNode
extends MXMLNodeBase
implements IMXMLDeclarationsNode {
    private IMXMLInstanceNode[] declarationInstances;

    MXMLDeclarationsNode(NodeBase parent) {
        super(parent);
    }

    @Override
    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLFileScope fileScope = builder.getFileScope();
        if (fileScope.isComponentTag(childTag)) {
            MXMLComponentNode componentNode = new MXMLComponentNode(this);
            componentNode.initializeFromTag(builder, childTag);
            info.addChildNode(componentNode);
        } else if (fileScope.isModelTag(childTag)) {
            MXMLModelNode modelNode = new MXMLModelNode(this);
            modelNode.initializeFromTag(builder, childTag);
            info.addChildNode(modelNode);
        } else {
            RoyaleProject project = builder.getProject();
            IDefinition definition = builder.getFileScope().resolveTagToDefinition(childTag);
            if (definition instanceof ClassDefinition) {
                MXMLInstanceNode instanceNode = MXMLInstanceNode.createInstanceNode(builder, definition.getQualifiedName(), this);
                instanceNode.setClassReference(project, (IClassDefinition)definition);
                instanceNode.initializeFromTag(builder, childTag);
                info.addChildNode(instanceNode);
            } else {
                MXMLUnresolvedTagProblem problem = new MXMLUnresolvedTagProblem(childTag);
                builder.addProblem(problem);
                return;
            }
        }
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, IMXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        this.declarationInstances = info.getChildNodeList().toArray(new MXMLInstanceNode[0]);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLDeclarationsID;
    }

    @Override
    public IASNode getChild(int i) {
        return this.declarationInstances != null ? this.declarationInstances[i] : null;
    }

    @Override
    public int getChildCount() {
        return this.declarationInstances != null ? this.declarationInstances.length : 0;
    }

    @Override
    public String getName() {
        return "Declarations";
    }

    @Override
    public IMXMLInstanceNode[] getDeclarationInstanceNodes() {
        return this.declarationInstances;
    }

    void setDeclarationInstanceNodes(IMXMLInstanceNode[] declarationInstances) {
        this.declarationInstances = declarationInstances;
    }
}

