/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.ExpressionDecomposer;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.deps.ModuleNames;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;

public final class Es6ExtractClasses
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    static final String CLASS_DECL_VAR = "$classdecl$var";
    private final AbstractCompiler compiler;
    private final ExpressionDecomposer expressionDecomposer;
    private int classDeclVarCounter = 0;
    private static final FeatureSet features = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.CLASSES);

    Es6ExtractClasses(AbstractCompiler compiler) {
        this.compiler = compiler;
        HashSet<String> consts = new HashSet<String>();
        this.expressionDecomposer = new ExpressionDecomposer(compiler, compiler.getUniqueNameIdSupplier(), consts, Scope.createGlobalScope(new Node(Token.SCRIPT)), compiler.getOptions().allowMethodCallDecomposing());
    }

    @Override
    public void process(Node externs, Node root) {
        TranspilationPasses.processTranspile(this.compiler, externs, features, this, new SelfReferenceRewriter());
        TranspilationPasses.processTranspile(this.compiler, root, features, this, new SelfReferenceRewriter());
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        TranspilationPasses.hotSwapTranspile(this.compiler, scriptRoot, features, this, new SelfReferenceRewriter());
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isClass() && this.shouldExtractClass(n, parent)) {
            this.extractClass(t, n, parent);
        }
    }

    private boolean shouldExtractClass(Node classNode, Node parent) {
        boolean isAnonymous = classNode.getFirstChild().isEmpty();
        if (NodeUtil.isClassDeclaration(classNode) || isAnonymous && parent.isName() || isAnonymous && parent.isAssign() && parent.getFirstChild().isQualifiedName() && parent.getParent().isExprResult()) {
            return false;
        }
        if (NodeUtil.mayHaveSideEffects(classNode, this.compiler) || this.expressionDecomposer.canExposeExpression(classNode) != ExpressionDecomposer.DecompositionType.MOVABLE) {
            this.compiler.report(JSError.make(classNode, Es6ToEs3Util.CANNOT_CONVERT, "class expression that cannot be extracted"));
            return false;
        }
        return true;
    }

    private void extractClass(NodeTraversal t, Node classNode, Node parent) {
        Node expr;
        String name = ModuleNames.fileToJsIdentifier(classNode.getStaticSourceFile().getName()) + CLASS_DECL_VAR + this.classDeclVarCounter++;
        JSDocInfo info = NodeUtil.getBestJSDocInfo(classNode);
        Node statement = NodeUtil.getEnclosingStatement(parent);
        JSType classType = classNode.getJSType();
        Preconditions.checkState(!this.compiler.hasTypeCheckingRun() || classType != null);
        Node classNameLhs = IR.name(name).setJSType(classType);
        Node classNameRhs = classNameLhs.cloneTree();
        parent.replaceChild(classNode, classNameRhs);
        Node classDeclaration = IR.constNode(classNameLhs, classNode).useSourceInfoIfMissingFromForTree(classNode);
        NodeUtil.addFeatureToScript(t.getCurrentFile(), FeatureSet.Feature.CONST_DECLARATIONS);
        classDeclaration.setJSDocInfo(JSDocInfoBuilder.maybeCopyFrom(info).build());
        statement.getParent().addChildBefore(classDeclaration, statement);
        if (NodeUtil.isNameDeclaration(statement) && statement.hasOneChild() && statement.getOnlyChild() == parent) {
            this.addAtConstructor(statement);
        } else if (statement.isExprResult() && (expr = statement.getOnlyChild()).isAssign() && expr.getFirstChild().isQualifiedName() && expr.getSecondChild() == classNameRhs) {
            this.addAtConstructor(expr);
        }
        this.compiler.reportChangeToEnclosingScope(classDeclaration);
    }

    private void addAtConstructor(Node node) {
        JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(node.getJSDocInfo());
        builder.recordConstructor();
        node.setJSDocInfo(builder.build());
    }

    private class SelfReferenceRewriter
    implements NodeTraversal.Callback {
        private final Deque<ClassDescription> classStack = new ArrayDeque<ClassDescription>();

        private SelfReferenceRewriter() {
        }

        private boolean needsInnerNameRewriting(Node classNode, Node parent) {
            Preconditions.checkArgument(classNode.isClass());
            return classNode.getFirstChild().isName() && parent.isName();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (n.isClass() && this.needsInnerNameRewriting(n, parent)) {
                this.classStack.addFirst(new ClassDescription(n.getFirstChild(), parent.getString()));
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case CLASS: {
                    if (!this.needsInnerNameRewriting(n, parent)) break;
                    this.classStack.removeFirst();
                    n.replaceChild(n.getFirstChild(), IR.empty().useSourceInfoFrom(n.getFirstChild()));
                    Es6ExtractClasses.this.compiler.reportChangeToEnclosingScope(n);
                    break;
                }
                case NAME: {
                    this.maybeUpdateClassSelfRef(t, n, parent);
                    break;
                }
            }
        }

        private void maybeUpdateClassSelfRef(NodeTraversal t, Node nameNode, Node parent) {
            for (ClassDescription klass : this.classStack) {
                Var var;
                if (nameNode == klass.nameNode || !nameNode.matchesQualifiedName(klass.nameNode) || (var = (Var)t.getScope().getVar(nameNode.getString())) == null || var.getNameNode() != klass.nameNode) continue;
                Node newNameNode = IR.name(klass.outerName).setJSType(nameNode.getJSType()).useSourceInfoFrom(nameNode);
                parent.replaceChild(nameNode, newNameNode);
                Es6ExtractClasses.this.compiler.reportChangeToEnclosingScope(newNameNode);
                return;
            }
        }

        private class ClassDescription {
            Node nameNode;
            String outerName;

            ClassDescription(Node nameNode, String outerName) {
                this.nameNode = nameNode;
                this.outerName = outerName;
            }
        }
    }
}

