/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;

public class FunctionParamBuilder {
    private final JSTypeRegistry registry;
    private final Node root = new Node(Token.PARAM_LIST);

    public FunctionParamBuilder(JSTypeRegistry registry) {
        this.registry = registry;
    }

    public boolean addRequiredParams(JSType ... types) {
        if (this.hasOptionalOrVarArgs()) {
            return false;
        }
        for (JSType type : types) {
            this.newParameter(type);
        }
        return true;
    }

    public boolean addOptionalParams(JSType ... types) {
        if (this.hasVarArgs()) {
            return false;
        }
        for (JSType type : types) {
            this.newParameter(this.registry.createOptionalType(type)).setOptionalArg(true);
        }
        return true;
    }

    public boolean addVarArgs(JSType type) {
        if (this.hasVarArgs()) {
            return false;
        }
        this.newParameter(type).setVarArgs(true);
        return true;
    }

    public Node newParameterFromNode(Node n) {
        Node newParam = this.newParameter(n.getJSType());
        newParam.setVarArgs(n.isVarArgs());
        newParam.setOptionalArg(n.isOptionalArg());
        return newParam;
    }

    public Node newOptionalParameterFromNode(Node n) {
        Node newParam = this.newParameterFromNode(n);
        if (!newParam.isVarArgs() && !newParam.isOptionalArg()) {
            newParam.setOptionalArg(true);
        }
        return newParam;
    }

    private Node newParameter(JSType type) {
        Node paramNode = Node.newString(Token.NAME, "");
        paramNode.setJSType(type);
        this.root.addChildToBack(paramNode);
        return paramNode;
    }

    public Node build() {
        return this.root;
    }

    private boolean hasOptionalOrVarArgs() {
        Node lastChild = this.root.getLastChild();
        return lastChild != null && (lastChild.isOptionalArg() || lastChild.isVarArgs());
    }

    public boolean hasVarArgs() {
        Node lastChild = this.root.getLastChild();
        return lastChild != null && lastChild.isVarArgs();
    }
}

