/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.filespecs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.utils.FilenameNormalization;

public class CombinedFile
implements IFileSpecification {
    private StringBuilder combinedSource = null;
    private final String sourceFilename;
    private final List<String> fileList;

    public CombinedFile(List<String> includedFilenames, String sourceFilename) {
        this.sourceFilename = FilenameNormalization.normalize(sourceFilename);
        this.fileList = includedFilenames;
        this.fileList.add(sourceFilename);
    }

    @Override
    public String getPath() {
        return this.sourceFilename;
    }

    @Override
    public Reader createReader() throws FileNotFoundException {
        if (this.combinedSource == null) {
            this.combineFile();
        }
        return new StringReader(this.combinedSource.toString());
    }

    @Override
    public long getLastModified() {
        long lastModified = 0L;
        for (String file : this.fileList) {
            long timestamp = new File(file).lastModified();
            lastModified = Math.max(lastModified, timestamp);
        }
        return lastModified;
    }

    @Override
    public boolean isOpenDocument() {
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void combineFile() throws FileNotFoundException {
        assert (this.combinedSource == null) : "Do not call combineFile() twice.";
        this.combinedSource = new StringBuilder();
        Iterator<String> iterator = this.fileList.iterator();
        while (iterator.hasNext()) {
            String filename = iterator.next();
            InputStreamReader reader = null;
            try {
                BufferedInputStream strm = CombinedFile.getStreamAndSkipBOM(filename);
                reader = new InputStreamReader(strm);
                this.combinedSource.append(IOUtils.toString(reader));
                this.combinedSource.append(IOUtils.LINE_SEPARATOR);
            }
            catch (FileNotFoundException e) {
                try {
                    throw e;
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(reader);
        }
        return;
    }

    public static BufferedInputStream getStreamAndSkipBOM(String filename) throws IOException {
        File file = new File(filename);
        BufferedInputStream strm = new BufferedInputStream(new FileInputStream(file));
        BOM bom = CombinedFile.getBOM(strm);
        strm.skip(bom.pattern.length);
        return strm;
    }

    public static BOM getBOM(BufferedInputStream strm) throws IOException {
        assert (strm.markSupported()) : "getBOM call on stream which does not support mark";
        byte[] peek = new byte[4];
        strm.mark(4);
        strm.read(peek);
        strm.reset();
        byte[] quadruplet = Arrays.copyOf(peek, 4);
        if (Arrays.equals(BOM.UTF_32_BE.pattern, quadruplet)) {
            return BOM.UTF_32_BE;
        }
        if (Arrays.equals(BOM.UTF_32_LE.pattern, quadruplet)) {
            return BOM.UTF_32_LE;
        }
        byte[] triplet = Arrays.copyOf(peek, 3);
        if (Arrays.equals(BOM.UTF_8.pattern, triplet)) {
            return BOM.UTF_8;
        }
        byte[] twin = Arrays.copyOf(peek, 2);
        if (Arrays.equals(BOM.UTF_16_BE.pattern, twin)) {
            return BOM.UTF_16_BE;
        }
        if (Arrays.equals(BOM.UTF_16_LE.pattern, twin)) {
            return BOM.UTF_16_LE;
        }
        return BOM.NONE;
    }

    @Override
    public void setLastModified(long fileDate) {
    }

    public static enum BOM {
        NONE("UTF-8", new byte[0]),
        UTF_8("UTF-8", -17, -69, -65),
        UTF_16_LE("UTF-16LE", -1, -2),
        UTF_16_BE("UTF-16BE", -2, -1),
        UTF_32_LE("UTF-32LE", -1, -2, 0, 0),
        UTF_32_BE("UTF-32BE", 0, 0, -2, -1);

        public final byte[] pattern;
        public final Charset charset;

        private BOM(String charsetName, byte ... pattern) {
            this.charset = charsetName == null || !Charset.isSupported(charsetName) ? Charset.defaultCharset() : Charset.forName(charsetName);
            this.pattern = pattern;
        }
    }
}

