/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.utils;

import org.apache.royale.compiler.config.CompilerDiagnosticsConstants;
import org.apache.royale.utils.IntMap;
import org.apache.royale.utils.ListEntry;

public abstract class IntMapLRUCache {
    private IntMap map;
    private ListEntry head;
    private ListEntry tail;
    private int maxSize;
    private int purgeSize = 1;

    public IntMapLRUCache(int initialSize, int maxSize) {
        this(initialSize, maxSize, 1);
    }

    public IntMapLRUCache(int initialSize, int maxSize, int purgeSize) {
        this.maxSize = maxSize;
        this.purgeSize = purgeSize;
        if (initialSize < 1) {
            initialSize = 1;
        }
        this.map = new IntMap(initialSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int key) {
        ListEntry entry;
        Object value = null;
        if ((CompilerDiagnosticsConstants.diagnostics & 0x400) == 1024) {
            System.out.println("IntMapLRUCache waiting for lock in get");
        }
        IntMapLRUCache intMapLRUCache = this;
        synchronized (intMapLRUCache) {
            if (this.head != null && key == this.head.key) {
                return this.head.value;
            }
            entry = (ListEntry)this.map.get(key);
            if (entry != null) {
                this.setMostRecentlyUsed(entry);
                return entry.value;
            }
        }
        if ((CompilerDiagnosticsConstants.diagnostics & 0x400) == 1024) {
            System.out.println("IntMapLRUCache done with lock in get");
        }
        try {
            value = this.fetch(key);
            if ((CompilerDiagnosticsConstants.diagnostics & 0x400) == 1024) {
                System.out.println("IntMapLRUCache waiting for lock in get (2nd half)");
            }
            intMapLRUCache = this;
            synchronized (intMapLRUCache) {
                entry = new ListEntry();
                entry.key = key;
                entry.value = value;
                this.map.put(key, entry);
            }
            if ((CompilerDiagnosticsConstants.diagnostics & 0x400) == 1024) {
                System.out.println("IntMapLRUCache done with lock in get (2nd half)");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int firstKey() {
        if ((CompilerDiagnosticsConstants.diagnostics & 0x400) == 1024) {
            System.out.println("IntMapLRUCache waiting for lock in firstKey");
        }
        IntMapLRUCache intMapLRUCache = this;
        synchronized (intMapLRUCache) {
            int ret = 0;
            if (this.head != null) {
                ret = this.head.key;
            }
            if ((CompilerDiagnosticsConstants.diagnostics & 0x400) == 1024) {
                System.out.println("IntMapLRUCache done with lock in firstKey");
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(int key, Object value) {
        ListEntry entry = new ListEntry();
        entry.value = value;
        entry.key = key;
        if ((CompilerDiagnosticsConstants.diagnostics & 0x400) == 1024) {
            System.out.println("IntMapLRUCache waiting for lock in put");
        }
        IntMapLRUCache intMapLRUCache = this;
        synchronized (intMapLRUCache) {
            this.map.put(key, entry);
            this.setMostRecentlyUsed(entry);
            if (this.tail == null) {
                this.tail = entry;
            }
            if (this.size() > this.maxSize) {
                this.purgeLRUElements();
            }
        }
        if ((CompilerDiagnosticsConstants.diagnostics & 0x400) == 1024) {
            System.out.println("IntMapLRUCache done with lock in put");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int key) {
        if ((CompilerDiagnosticsConstants.diagnostics & 0x400) == 1024) {
            System.out.println("IntMapLRUCache waiting for lock in remove");
        }
        IntMapLRUCache intMapLRUCache = this;
        synchronized (intMapLRUCache) {
            ListEntry entry = (ListEntry)this.map.remove(key);
            if (entry != null) {
                if (entry == this.head) {
                    this.head = entry.next;
                }
                if (entry == this.tail) {
                    this.tail = entry.prev;
                }
                if (entry.prev != null) {
                    entry.prev.next = entry.next;
                }
                if (entry.next != null) {
                    entry.next.prev = entry.prev;
                }
            }
        }
        if ((CompilerDiagnosticsConstants.diagnostics & 0x400) == 1024) {
            System.out.println("IntMapLRUCache done with lock in remove");
        }
    }

    public void setSize(int size) {
    }

    public int size() {
        return this.map.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getPurgeSize() {
        return this.purgeSize;
    }

    protected void handleLRUElementPurged(int key, Object value) {
    }

    private void purgeLRUElements() {
        for (int i = 0; i < this.purgeSize && this.tail != null; ++i) {
            int key = this.tail.key;
            Object value = this.tail.value;
            this.remove(this.tail.key);
            this.handleLRUElementPurged(key, value);
        }
    }

    private void setMostRecentlyUsed(ListEntry entry) {
        if (entry.prev != null) {
            entry.prev.next = entry.next;
            if (entry == this.tail) {
                this.tail = entry.prev;
                this.tail.next = null;
            }
        }
        if (entry.next != null) {
            entry.next.prev = entry.prev;
        }
        entry.prev = null;
        entry.next = this.head;
        if (this.head != null) {
            this.head.prev = entry;
        }
        this.head = entry;
    }

    public abstract Object fetch(int var1);
}

