/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.tasks;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.royale.test.ant.tasks.Compilation;
import org.apache.royale.test.ant.tasks.TestRun;
import org.apache.royale.test.ant.tasks.configuration.TaskConfiguration;
import org.apache.royale.test.ant.tasks.types.LoadConfig;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.DynamicElement;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class RoyaleUnitTask
extends Task
implements DynamicElement,
DynamicAttribute {
    private static final Pattern COMMAND_ARGS_PATTERN = Pattern.compile("([\\-+]([^\\s]+\\+?=)(('([^'])*')|(\"([^\"])*\")|([^\\s\"',]+))(,(('([^'])*')|(\"([^\"])*\")|([^\\s\"']+)))*)|('([^'])*')|(\"([^\"])*\")|([^\\s\"']+)");
    private TaskConfiguration configuration;

    public void setProject(Project project) {
        super.setProject(project);
        this.configuration = new TaskConfiguration(project);
    }

    public void setLocalTrusted(boolean localTrusted) {
        this.configuration.setLocalTrusted(localTrusted);
    }

    public void setPort(int serverPort) {
        this.configuration.setPort(serverPort);
    }

    public void setTimeout(int timeout) {
        this.configuration.setSocketTimeout(timeout);
    }

    public void setBuffer(int size) {
        this.configuration.setServerBufferSize(size);
    }

    public void setSWF(String testSWF) {
        this.configuration.setSwf(testSWF);
    }

    public void setToDir(String toDir) {
        this.configuration.setReportDir(toDir);
    }

    public void setHaltonfailure(boolean fail) {
        this.configuration.setFailOnTestFailure(fail);
    }

    public void setFailureproperty(String failprop) {
        this.configuration.setFailureProperty(failprop);
    }

    public void setVerbose(boolean verbose) {
        this.configuration.setVerbose(verbose);
    }

    public void setPlayer(String player) {
        this.configuration.setPlayer(player);
    }

    public void setCommand(String executableFilePath) {
        this.configuration.setCommand(executableFilePath);
    }

    public void setHeadless(boolean headless) {
        this.configuration.setHeadless(headless);
    }

    public void setDisplay(int number) {
        this.configuration.setDisplay(number);
    }

    public void addSource(FileSet fileset) {
        this.configuration.addSource(fileset);
    }

    public void addTestSource(FileSet fileset) {
        this.configuration.addTestSource(fileset);
    }

    public void addLibrary(FileSet fileset) {
        this.configuration.addLibrary(fileset);
    }

    public void setWorkingDir(String workingDirPath) {
        this.configuration.setWorkingDir(workingDirPath);
    }

    public void execute() throws BuildException {
        this.configuration.verify();
        if (this.configuration.shouldCompile()) {
            Compilation compilation = new Compilation(this.getProject(), this.configuration.getCompilationConfiguration());
            this.configuration.setSwf(compilation.compile());
        }
        TestRun testRun = new TestRun(this.getProject(), this.configuration.getTestRunConfiguration());
        testRun.run();
    }

    public void setDebug(boolean value) {
        this.configuration.setDebug(value);
    }

    public Object createDynamicElement(String arg0) throws BuildException {
        if ("load-config".equals(arg0)) {
            LoadConfig loadconfig = new LoadConfig();
            this.configuration.setLoadConfig(loadconfig);
            return loadconfig;
        }
        throw new BuildException("The <royaleUnit> type doesn't support the " + arg0 + " nested element");
    }

    public void setDynamicAttribute(String arg0, String arg1) throws BuildException {
        if ("commandargs".equals(arg0)) {
            if (arg1.length() > 0) {
                String[] commandArgs = this.parseCommandArgs(arg1);
                this.configuration.setCommandArgs(commandArgs);
            } else {
                this.configuration.setCommandArgs(null);
            }
        } else {
            throw new BuildException("The <royaleUnit> type doesn't support the " + arg0 + " attribute");
        }
    }

    private String[] parseCommandArgs(String combined) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = COMMAND_ARGS_PATTERN.matcher(combined);
        while (matcher.find()) {
            String option = matcher.group();
            result.add(option);
        }
        return result.toArray(new String[0]);
    }
}

