/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.projects;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.royale.compiler.common.DependencyType;
import org.apache.royale.compiler.common.DependencyTypeSet;
import org.apache.royale.compiler.exceptions.CircularDependencyException;
import org.apache.royale.compiler.exceptions.LibraryCircularDependencyException;
import org.apache.royale.compiler.internal.graph.Graph;
import org.apache.royale.compiler.internal.graph.GraphEdge;
import org.apache.royale.compiler.internal.graph.TopologicalSort;

public class LibraryDependencyGraph {
    private final Graph<String, Edge> graph = new Graph();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependency(String depender, String dependee, Map<String, DependencyTypeSet> dependencies) {
        this.lock.writeLock().lock();
        try {
            Edge e = this.getEdge(depender, dependee);
            for (Map.Entry<String, DependencyTypeSet> entry : dependencies.entrySet()) {
                e.addDependency(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addLibrary(String library) {
        this.graph.addVertex(library);
    }

    private Edge getEdge(String dependentLibrary, String dependeeLibrary) {
        Edge result = this.graph.getEdge(dependentLibrary, dependeeLibrary);
        if (result == null) {
            result = new Edge(dependentLibrary, dependeeLibrary);
            this.graph.setEdge(result);
        }
        return result;
    }

    public boolean contains(String library) {
        return this.graph.getVertices().contains(library);
    }

    public Map<String, DependencyTypeSet> getDependencySet(String from, String to) {
        return new HashMap<String, DependencyTypeSet>(this.getEdge(from, to).getNamedDependencies());
    }

    public DependencyTypeSet getDependencyTypes(String from, String to) {
        return DependencyTypeSet.copyOf(this.getEdge(from, to).getAllDependencies());
    }

    public List<String> getDependencyOrder() throws LibraryCircularDependencyException {
        List<String> sortedSWCs;
        try {
            sortedSWCs = TopologicalSort.sort(this.graph, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
        }
        catch (CircularDependencyException e) {
            ArrayList<String> circularDependency = new ArrayList<String>(e.getCircularDependency().size());
            for (Object dependency : e.getCircularDependency()) {
                circularDependency.add((String)dependency);
            }
            throw new LibraryCircularDependencyException("The libraries contain a circular dependency.", circularDependency);
        }
        return sortedSWCs;
    }

    public Set<String> getDependencies(String libraryPath) {
        HashSet<String> libraries = new HashSet<String>();
        Set<Edge> edges = this.graph.getOutgoingEdges(libraryPath);
        for (Edge edge : edges) {
            libraries.add((String)edge.getTo());
        }
        return libraries;
    }

    static final class Edge
    extends GraphEdge<String>
    implements Comparable<Edge> {
        private Map<String, DependencyTypeSet> dependencies;
        private DependencyTypeSet dependencySet = DependencyTypeSet.noneOf();

        private Edge(String referencingLibrary, String declaringLibrary) {
            super(referencingLibrary, declaringLibrary);
            this.dependencies = new HashMap<String, DependencyTypeSet>();
        }

        public boolean getIsInheritanceDependency() {
            return this.dependencySet.contains(DependencyType.INHERITANCE);
        }

        public boolean getIsSignatureDependency() {
            return this.dependencySet.contains(DependencyType.SIGNATURE);
        }

        public boolean getIsNamespaceDependency() {
            return this.dependencySet.contains(DependencyType.NAMESPACE);
        }

        public boolean getIsExpressionDependency() {
            return this.dependencySet.contains(DependencyType.EXPRESSION);
        }

        public boolean typeInSet(DependencyTypeSet set) {
            for (DependencyType t : set) {
                if (!this.dependencySet.contains(t)) continue;
                return true;
            }
            return false;
        }

        public void addDependency(String qname, DependencyTypeSet types) {
            DependencyTypeSet typeSet = this.dependencies.get(qname);
            if (typeSet != null) {
                DependencyTypeSet newTypeSet = DependencyTypeSet.copyOf(typeSet);
                newTypeSet.addAll(types);
                this.dependencies.put(qname, newTypeSet);
            } else {
                this.dependencies.put(qname, types);
            }
            this.dependencySet.addAll(types);
        }

        public void addDependency(DependencyType type) {
            this.dependencySet.add(type);
        }

        public String toString() {
            String result = (String)this.getFrom() + " -> " + (String)this.getTo() + " [ ";
            if (this.getIsInheritanceDependency()) {
                result = result + "inheritance ";
            }
            if (this.getIsSignatureDependency()) {
                result = result + "signature ";
            }
            if (this.getIsNamespaceDependency()) {
                result = result + "namespace ";
            }
            if (this.getIsExpressionDependency()) {
                result = result + "expression ";
            }
            result = result + "]";
            return result;
        }

        public Map<String, DependencyTypeSet> getNamedDependencies() {
            return this.dependencies;
        }

        @Override
        public int compareTo(Edge edge2) {
            int fromCompare = ((String)this.getTo()).compareTo((String)edge2.getTo());
            if (fromCompare == 0) {
                return ((String)this.getTo()).compareTo((String)edge2.getTo());
            }
            return fromCompare;
        }

        public DependencyTypeSet getAllDependencies() {
            return this.dependencySet;
        }
    }
}

