/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js;

import com.google.debugging.sourcemap.FilePosition;
import java.io.FilterWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.royale.compiler.codegen.IDocEmitter;
import org.apache.royale.compiler.codegen.IEmitter;
import org.apache.royale.compiler.codegen.ISubEmitter;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.codegen.js.IMappingEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IAppliedVectorDefinition;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTag;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.internal.codegen.as.ASEmitter;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.jx.BlockCloseEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.BlockOpenEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.CatchEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.DoWhileLoopEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.DynamicAccessEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ForLoopEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.FunctionCallArgumentsEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.IfEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.IterationFlowEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.LanguageIdentifierEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.LiteralContainerEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.MemberKeywordEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.NumericLiteralEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ObjectLiteralValuePairEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ParameterEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ParametersEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ReturnEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.SourceMapDirectiveEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.StatementEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.SwitchEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.TernaryOperatorEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ThrowEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.TryEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.UnaryOperatorEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.WhileLoopEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.WithEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.semantics.SemanticUtils;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorAsNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorInstanceOfNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FunctionCallNode;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.as.TypedExpressionNode;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.ICatchNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IForLoopNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IFunctionObjectNode;
import org.apache.royale.compiler.tree.as.IIfNode;
import org.apache.royale.compiler.tree.as.IImportNode;
import org.apache.royale.compiler.tree.as.IIterationFlowNode;
import org.apache.royale.compiler.tree.as.ILanguageIdentifierNode;
import org.apache.royale.compiler.tree.as.ILiteralContainerNode;
import org.apache.royale.compiler.tree.as.INumericLiteralNode;
import org.apache.royale.compiler.tree.as.IObjectLiteralValuePairNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IReturnNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.ISwitchNode;
import org.apache.royale.compiler.tree.as.ITernaryOperatorNode;
import org.apache.royale.compiler.tree.as.IThrowNode;
import org.apache.royale.compiler.tree.as.ITryNode;
import org.apache.royale.compiler.tree.as.ITypeNode;
import org.apache.royale.compiler.tree.as.ITypedExpressionNode;
import org.apache.royale.compiler.tree.as.IUnaryOperatorNode;
import org.apache.royale.compiler.tree.as.IWhileLoopNode;
import org.apache.royale.compiler.tree.as.IWithNode;
import org.apache.royale.compiler.utils.DefinitionUtils;
import org.apache.royale.compiler.utils.NativeUtils;

public class JSEmitter
extends ASEmitter
implements IJSEmitter {
    private JSSessionModel model = new JSSessionModel();
    public ISubEmitter<IContainerNode> blockOpenEmitter;
    public ISubEmitter<IContainerNode> blockCloseEmitter;
    public ISubEmitter<INumericLiteralNode> numericLiteralEmitter;
    public ISubEmitter<IContainerNode> parametersEmitter;
    public ISubEmitter<IParameterNode> parameterEmitter;
    public ISubEmitter<IContainerNode> functionCallArgumentsEmitter;
    public ISubEmitter<ILiteralContainerNode> literalContainerEmitter;
    public ISubEmitter<IObjectLiteralValuePairNode> objectLiteralValuePairEmitter;
    public ISubEmitter<IReturnNode> returnEmitter;
    public ISubEmitter<IDynamicAccessNode> dynamicAccessEmitter;
    public ISubEmitter<IUnaryOperatorNode> unaryOperatorEmitter;
    public ISubEmitter<ITernaryOperatorNode> ternaryOperatorEmitter;
    public ISubEmitter<IDefinitionNode> memberKeywordEmitter;
    public ISubEmitter<IIfNode> ifEmitter;
    public ISubEmitter<ISwitchNode> switchEmitter;
    public ISubEmitter<IWhileLoopNode> whileLoopEmitter;
    public ISubEmitter<IWhileLoopNode> doWhileLoopEmitter;
    public ISubEmitter<IForLoopNode> forLoopEmitter;
    public ISubEmitter<IIterationFlowNode> interationFlowEmitter;
    public ISubEmitter<ITryNode> tryEmitter;
    public ISubEmitter<ICatchNode> catchEmitter;
    public ISubEmitter<IThrowNode> throwEmitter;
    public ISubEmitter<IWithNode> withEmitter;
    public ISubEmitter<IASNode> statementEmitter;
    public ISubEmitter<ILanguageIdentifierNode> languageIdentifierEmitter;
    public SourceMapDirectiveEmitter sourceMapDirectiveEmitter;
    private IMappingEmitter.SourceMapMapping lastMapping;
    private List<IMappingEmitter.SourceMapMapping> sourceMapMappings = new ArrayList<IMappingEmitter.SourceMapMapping>();

    @Override
    public JSSessionModel getModel() {
        return this.model;
    }

    @Override
    public List<IMappingEmitter.SourceMapMapping> getSourceMapMappings() {
        return this.sourceMapMappings;
    }

    public JSEmitter(FilterWriter out) {
        super(out);
        this.blockOpenEmitter = new BlockOpenEmitter(this);
        this.blockCloseEmitter = new BlockCloseEmitter(this);
        this.numericLiteralEmitter = new NumericLiteralEmitter(this);
        this.parametersEmitter = new ParametersEmitter(this);
        this.parameterEmitter = new ParameterEmitter(this);
        this.functionCallArgumentsEmitter = new FunctionCallArgumentsEmitter(this);
        this.literalContainerEmitter = new LiteralContainerEmitter(this);
        this.objectLiteralValuePairEmitter = new ObjectLiteralValuePairEmitter(this);
        this.returnEmitter = new ReturnEmitter(this);
        this.dynamicAccessEmitter = new DynamicAccessEmitter(this);
        this.unaryOperatorEmitter = new UnaryOperatorEmitter(this);
        this.ternaryOperatorEmitter = new TernaryOperatorEmitter(this);
        this.memberKeywordEmitter = new MemberKeywordEmitter(this);
        this.ifEmitter = new IfEmitter(this);
        this.switchEmitter = new SwitchEmitter(this);
        this.whileLoopEmitter = new WhileLoopEmitter(this);
        this.doWhileLoopEmitter = new DoWhileLoopEmitter(this);
        this.forLoopEmitter = new ForLoopEmitter(this);
        this.interationFlowEmitter = new IterationFlowEmitter(this);
        this.tryEmitter = new TryEmitter(this);
        this.catchEmitter = new CatchEmitter(this);
        this.throwEmitter = new ThrowEmitter(this);
        this.withEmitter = new WithEmitter(this);
        this.statementEmitter = new StatementEmitter(this);
        this.languageIdentifierEmitter = new LanguageIdentifierEmitter(this);
        this.sourceMapDirectiveEmitter = new SourceMapDirectiveEmitter(this);
    }

    @Override
    public String formatQualifiedName(String name) {
        return name;
    }

    @Override
    public void emitLocalNamedFunction(IFunctionNode node) {
        this.startMapping((ISourceLocation)node);
        FunctionNode fnode = (FunctionNode)node;
        this.write(ASEmitterTokens.FUNCTION);
        this.write(ASEmitterTokens.SPACE);
        this.write(fnode.getName());
        this.endMapping((ISourceLocation)node);
        this.emitParameters((IContainerNode)fnode.getParametersContainerNode());
        this.emitFunctionScope((IScopedNode)fnode.getScopedNode());
    }

    @Override
    public void emitFunctionObject(IFunctionObjectNode node) {
        this.startMapping((ISourceLocation)node);
        FunctionNode fnode = node.getFunctionNode();
        this.write(ASEmitterTokens.FUNCTION);
        String name = fnode.getName();
        if (name.length() > 0) {
            this.write(ASEmitterTokens.SPACE);
            this.write(name);
        }
        this.endMapping((ISourceLocation)node);
        this.emitParameters((IContainerNode)fnode.getParametersContainerNode());
        this.emitFunctionScope((IScopedNode)fnode.getScopedNode());
    }

    @Override
    public void emitClosureStart() {
    }

    @Override
    public void emitClosureEnd(IASNode node, IDefinition nodeDef) {
    }

    @Override
    public void emitSourceMapDirective(ITypeNode node) {
        this.sourceMapDirectiveEmitter.isExterns = this.getModel().isExterns;
        this.sourceMapDirectiveEmitter.emit(node);
    }

    @Override
    public void emitParameters(IContainerNode node) {
        this.parametersEmitter.emit(node);
    }

    @Override
    public void emitParameter(IParameterNode node) {
        this.parameterEmitter.emit(node);
    }

    @Override
    public void emitArguments(IContainerNode node) {
        this.functionCallArgumentsEmitter.emit(node);
    }

    @Override
    public void emitNumericLiteral(INumericLiteralNode node) {
        this.numericLiteralEmitter.emit(node);
    }

    @Override
    public void emitLiteralContainer(ILiteralContainerNode node) {
        this.literalContainerEmitter.emit(node);
    }

    @Override
    public void emitObjectLiteralValuePair(IObjectLiteralValuePairNode node) {
        this.objectLiteralValuePairEmitter.emit(node);
    }

    @Override
    public void emitTry(ITryNode node) {
        this.tryEmitter.emit(node);
    }

    @Override
    public void emitCatch(ICatchNode node) {
        this.catchEmitter.emit(node);
    }

    @Override
    public void emitWith(IWithNode node) {
        this.withEmitter.emit(node);
    }

    @Override
    public void emitThrow(IThrowNode node) {
        this.throwEmitter.emit(node);
    }

    @Override
    public void emitReturn(IReturnNode node) {
        this.returnEmitter.emit(node);
    }

    @Override
    public void emitTypedExpression(ITypedExpressionNode node) {
        this.write(JSEmitterTokens.ARRAY);
    }

    @Override
    public void emitDynamicAccess(IDynamicAccessNode node) {
        this.dynamicAccessEmitter.emit(node);
    }

    @Override
    public void emitMemberKeyword(IDefinitionNode node) {
        this.memberKeywordEmitter.emit(node);
    }

    @Override
    public void emitUnaryOperator(IUnaryOperatorNode node) {
        this.unaryOperatorEmitter.emit(node);
    }

    @Override
    public void emitTernaryOperator(ITernaryOperatorNode node) {
        this.ternaryOperatorEmitter.emit(node);
    }

    @Override
    public void emitLanguageIdentifier(ILanguageIdentifierNode node) {
        this.languageIdentifierEmitter.emit(node);
    }

    @Override
    public void emitStatement(IASNode node) {
        this.statementEmitter.emit(node);
    }

    @Override
    public void emitIf(IIfNode node) {
        this.ifEmitter.emit(node);
    }

    @Override
    public void emitSwitch(ISwitchNode node) {
        this.switchEmitter.emit(node);
    }

    @Override
    public void emitImport(IImportNode node) {
    }

    @Override
    public void emitWhileLoop(IWhileLoopNode node) {
        this.whileLoopEmitter.emit(node);
    }

    @Override
    public void emitDoLoop(IWhileLoopNode node) {
        this.doWhileLoopEmitter.emit(node);
    }

    @Override
    public void emitForLoop(IForLoopNode node) {
        this.forLoopEmitter.emit(node);
    }

    @Override
    public void emitIterationFlow(IIterationFlowNode node) {
        this.interationFlowEmitter.emit(node);
    }

    @Override
    public void emitBlockOpen(IContainerNode node) {
        this.blockOpenEmitter.emit(node);
    }

    @Override
    public void emitBlockClose(IContainerNode node) {
        this.blockCloseEmitter.emit(node);
    }

    @Override
    public void startMapping(ISourceLocation node) {
        this.startMapping(node, node.getLine(), node.getColumn());
    }

    @Override
    public void startMapping(ISourceLocation node, int line, int column) {
        IASNode parentNode;
        if (this.isBufferWrite()) {
            return;
        }
        IEmitter parentEmitter = this.getParentEmitter();
        if (parentEmitter != null && parentEmitter instanceof IMappingEmitter) {
            IMappingEmitter mappingParent = (IMappingEmitter)((Object)parentEmitter);
            mappingParent.startMapping(node, line, column);
            return;
        }
        if (this.lastMapping != null) {
            FilePosition sourceStartPosition = this.lastMapping.sourceStartPosition;
            throw new IllegalStateException("Cannot start new mapping when another mapping is already started. Previous mapping at Line " + sourceStartPosition.getLine() + " and Column " + sourceStartPosition.getColumn() + " in file " + this.lastMapping.sourcePath);
        }
        String sourcePath = node.getSourcePath();
        if (sourcePath == null && node instanceof IASNode && (parentNode = ((IASNode)node).getParent()) != null) {
            this.startMapping((ISourceLocation)parentNode, line, column);
            return;
        }
        sourcePath = sourcePath.replace('\\', '/');
        IMappingEmitter.SourceMapMapping mapping = new IMappingEmitter.SourceMapMapping();
        mapping.sourcePath = sourcePath;
        mapping.sourceStartPosition = new FilePosition(line, column);
        mapping.destStartPosition = new FilePosition(this.getCurrentLine(), this.getCurrentColumn());
        this.lastMapping = mapping;
    }

    @Override
    public void startMapping(ISourceLocation node, ISourceLocation afterNode) {
        this.startMapping(node, afterNode.getEndLine(), afterNode.getEndColumn());
    }

    @Override
    public void endMapping(ISourceLocation node) {
        if (this.isBufferWrite()) {
            return;
        }
        IEmitter parentEmitter = this.getParentEmitter();
        if (parentEmitter != null && parentEmitter instanceof IMappingEmitter) {
            IMappingEmitter mappingParent = (IMappingEmitter)((Object)parentEmitter);
            mappingParent.endMapping(node);
            return;
        }
        if (this.lastMapping == null) {
            throw new IllegalStateException("Cannot end mapping when a mapping has not been started");
        }
        this.lastMapping.destEndPosition = new FilePosition(this.getCurrentLine(), this.getCurrentColumn());
        this.sourceMapMappings.add(this.lastMapping);
        this.lastMapping = null;
    }

    protected void addLineToMappings(int lineIndex) {
        for (IMappingEmitter.SourceMapMapping mapping : this.sourceMapMappings) {
            FilePosition destStartPosition = mapping.destStartPosition;
            int startLine = destStartPosition.getLine();
            if (startLine <= lineIndex) continue;
            mapping.destStartPosition = new FilePosition(startLine + 1, destStartPosition.getColumn());
            FilePosition destEndPosition = mapping.destEndPosition;
            mapping.destEndPosition = new FilePosition(destEndPosition.getLine() + 1, destEndPosition.getColumn());
        }
    }

    protected void removeLineFromMappings(int lineIndex) {
        for (IMappingEmitter.SourceMapMapping mapping : this.sourceMapMappings) {
            FilePosition destStartPosition = mapping.destStartPosition;
            int startLine = destStartPosition.getLine();
            if (startLine <= lineIndex) continue;
            mapping.destStartPosition = new FilePosition(startLine - 1, destStartPosition.getColumn());
            FilePosition destEndPosition = mapping.destEndPosition;
            mapping.destEndPosition = new FilePosition(destEndPosition.getLine() - 1, destEndPosition.getColumn());
        }
    }

    @Override
    public String formatPrivateName(String className, String name) {
        return className.replace(".", "_") + "_" + name;
    }

    @Override
    public String formatPrivateName(String className, String name, Boolean nameFirst) {
        if (nameFirst.booleanValue()) {
            return name + "_" + className.replace(".", "_");
        }
        return this.formatPrivateName(className, name);
    }

    @Override
    public void emitAssignmentCoercion(IExpressionNode assignedNode, IDefinition definition) {
        JSRoyaleDocEmitter royaleDocEmitter;
        IDocEmitter docEmitter;
        boolean needsCoercion;
        IDefinition assignedDef = null;
        ITypeDefinition assignedTypeDef = null;
        ICompilerProject project = this.getWalker().getProject();
        boolean isXML = false;
        if (assignedNode != null) {
            assignedDef = assignedNode.resolve(project);
            assignedTypeDef = assignedNode.resolveType(project);
            if (assignedTypeDef == null || project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE).equals(assignedTypeDef)) {
                IDefinition resolvedXMLDef = SemanticUtils.resolveXML((IExpressionNode)assignedNode, (ICompilerProject)project);
                if (resolvedXMLDef != null) {
                    assignedDef = resolvedXMLDef;
                    assignedTypeDef = SemanticUtils.resolveTypeXML((IExpressionNode)assignedNode, (ICompilerProject)project);
                    isXML = true;
                }
            } else if (SemanticUtils.isXMLish((IDefinition)assignedTypeDef, (ICompilerProject)project)) {
                isXML = true;
            }
        }
        String coercionStart = null;
        String coercionEnd = null;
        boolean avoidCoercion = false;
        if (project.getBuiltinType(IASLanguageConstants.BuiltinType.INT).equals(definition)) {
            needsCoercion = false;
            if (assignedNode instanceof INumericLiteralNode) {
                INumericLiteralNode numericLiteral = (INumericLiteralNode)assignedNode;
                INumericLiteralNode.INumericValue numericValue = numericLiteral.getNumericValue();
                this.startMapping((ISourceLocation)assignedNode);
                if (numericValue.toString().startsWith("0x")) {
                    this.write("0x" + Integer.toHexString(numericValue.toInt32()));
                } else {
                    this.write(Integer.toString(numericValue.toInt32()));
                }
                this.endMapping((ISourceLocation)assignedNode);
                return;
            }
            if (assignedNode instanceof BinaryOperatorAsNode) {
                needsCoercion = true;
            } else if (!project.getBuiltinType(IASLanguageConstants.BuiltinType.INT).equals(assignedTypeDef)) {
                needsCoercion = true;
            }
            if (needsCoercion) {
                coercionStart = "(";
                coercionEnd = ") >> 0";
            }
        } else if (project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT).equals(definition)) {
            needsCoercion = false;
            if (assignedNode instanceof INumericLiteralNode) {
                INumericLiteralNode numericLiteral = (INumericLiteralNode)assignedNode;
                INumericLiteralNode.INumericValue numericValue = numericLiteral.getNumericValue();
                this.startMapping((ISourceLocation)assignedNode);
                if (numericValue.toString().startsWith("0x")) {
                    this.write("0x" + Long.toHexString(numericValue.toUint32()));
                } else {
                    this.write(Long.toString(numericValue.toUint32()));
                }
                this.endMapping((ISourceLocation)assignedNode);
                return;
            }
            if (assignedNode instanceof BinaryOperatorAsNode) {
                needsCoercion = true;
            } else if (!project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT).equals(assignedTypeDef)) {
                needsCoercion = true;
            }
            if (needsCoercion) {
                coercionStart = "(";
                coercionEnd = ") >>> 0";
            }
        } else if (project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER).equals(definition) && !project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER).equals(assignedTypeDef) && !project.getBuiltinType(IASLanguageConstants.BuiltinType.INT).equals(assignedTypeDef) && !project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT).equals(assignedTypeDef)) {
            needsCoercion = true;
            if (assignedNode instanceof IDynamicAccessNode) {
                ITypeDefinition leftDef;
                IDynamicAccessNode dynamicAccess = (IDynamicAccessNode)assignedNode;
                ITypeDefinition dynamicAccessIndexDef = dynamicAccess.getRightOperandNode().resolveType(project);
                if (project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER).equals(dynamicAccessIndexDef) && (leftDef = dynamicAccess.getLeftOperandNode().resolveType(project)) != null) {
                    IMetaTag[] metas;
                    for (IMetaTag meta : metas = leftDef.getAllMetaTags()) {
                        IMetaTagAttribute[] attrs;
                        if (!meta.getTagName().equals("ArrayElementType")) continue;
                        for (IMetaTagAttribute attr : attrs = meta.getAllAttributes()) {
                            String t = attr.getValue();
                            if (!t.equals("Number")) continue;
                            needsCoercion = false;
                            avoidCoercion = true;
                        }
                    }
                }
            }
            if (needsCoercion) {
                coercionStart = "Number(";
            }
        } else if (project.getBuiltinType(IASLanguageConstants.BuiltinType.BOOLEAN).equals(definition) && !project.getBuiltinType(IASLanguageConstants.BuiltinType.BOOLEAN).equals(assignedTypeDef)) {
            if (project.getBuiltinType(IASLanguageConstants.BuiltinType.NULL).equals(assignedTypeDef) || assignedDef != null && assignedDef.getQualifiedName().equals("undefined")) {
                this.startMapping((ISourceLocation)assignedNode);
                this.write("false");
                this.endMapping((ISourceLocation)assignedNode);
                return;
            }
            if (assignedNode instanceof INumericLiteralNode) {
                INumericLiteralNode numericLiteral = (INumericLiteralNode)assignedNode;
                INumericLiteralNode.INumericValue numericValue = numericLiteral.getNumericValue();
                String booleanValue = numericValue.toNumber() == 0.0 ? "false" : "true";
                this.startMapping((ISourceLocation)assignedNode);
                this.write(booleanValue);
                this.endMapping((ISourceLocation)assignedNode);
                return;
            }
            coercionStart = "!!(";
        } else if (!(!project.getBuiltinType(IASLanguageConstants.BuiltinType.STRING).equals(definition) || project.getBuiltinType(IASLanguageConstants.BuiltinType.STRING).equals(assignedTypeDef) || project.getBuiltinType(IASLanguageConstants.BuiltinType.NULL).equals(assignedTypeDef) || project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE).equals(assignedTypeDef) && SemanticUtils.isToStringFunctionCall((IExpressionNode)assignedNode, (ICompilerProject)project))) {
            if (assignedDef != null && assignedDef.getQualifiedName().equals("undefined")) {
                this.startMapping((ISourceLocation)assignedNode);
                this.write("null");
                this.endMapping((ISourceLocation)assignedNode);
                return;
            }
            boolean emitStringCoercion = true;
            docEmitter = this.getDocEmitter();
            if (docEmitter instanceof JSRoyaleDocEmitter) {
                royaleDocEmitter = (JSRoyaleDocEmitter)docEmitter;
                emitStringCoercion = royaleDocEmitter.emitStringConversions;
            }
            if (emitStringCoercion) {
                coercionStart = isXML ? (EmitterUtils.xmlRequiresNullCheck((NodeBase)assignedNode, project) ? "XMLList.coerce_string(" : "String(") : "org.apache.royale.utils.Language.string(";
            }
        }
        if (assignedDef != null && assignedDef instanceof IAppliedVectorDefinition && assignedNode instanceof TypedExpressionNode) {
            if (project instanceof RoyaleJSProject && ((RoyaleJSProject)project).config.getJsVectorEmulationClass() != null) {
                this.startMapping((ISourceLocation)assignedNode);
                this.write(((RoyaleJSProject)project).config.getJsVectorEmulationClass());
                this.endMapping((ISourceLocation)assignedNode);
            } else {
                this.startMapping((ISourceLocation)assignedNode);
                this.write(JSRoyaleEmitterTokens.SYNTH_VECTOR);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(this.formatQualifiedName(((TypedExpressionNode)assignedNode).getTypeNode().resolve(project).getQualifiedName()));
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                this.endMapping((ISourceLocation)assignedNode);
                if (project instanceof RoyaleJSProject) {
                    ((RoyaleJSProject)project).needLanguage = true;
                }
                this.getModel().needLanguage = true;
            }
            return;
        }
        if (assignedDef instanceof IClassDefinition && assignedNode instanceof IdentifierNode && ((IdentifierNode)assignedNode).getName().equals("Vector") && project instanceof RoyaleJSProject && ((RoyaleJSProject)project).config.getJsVectorEmulationClass() == null) {
            this.startMapping((ISourceLocation)assignedNode);
            this.write(JSRoyaleEmitterTokens.SYNTH_VECTOR);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.NULL);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.endMapping((ISourceLocation)assignedNode);
            if (project instanceof RoyaleJSProject) {
                ((RoyaleJSProject)project).needLanguage = true;
            }
            this.getModel().needLanguage = true;
            return;
        }
        if (DefinitionUtils.isRewrittenMultiCatchParam(assignedDef)) {
            avoidCoercion = true;
        }
        if (!(coercionStart != null || avoidCoercion || assignedTypeDef == null || definition == null || !project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE).equals(assignedTypeDef) && !project.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT).equals(assignedTypeDef) || project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE).equals(definition) || project.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT).equals(definition))) {
            needsCoercion = ((RoyaleJSProject)project).config.getJsComplexImplicitCoercions();
            docEmitter = this.getDocEmitter();
            if (docEmitter instanceof JSRoyaleDocEmitter) {
                royaleDocEmitter = (JSRoyaleDocEmitter)docEmitter;
                if (needsCoercion) {
                    needsCoercion = !royaleDocEmitter.getLocalSettingAsBoolean(JSRoyaleEmitterTokens.SUPPRESS_COMPLEX_IMPLICIT_COERCION, (Boolean)false);
                } else if (royaleDocEmitter.hasLocalSetting(JSRoyaleEmitterTokens.SUPPRESS_COMPLEX_IMPLICIT_COERCION.getToken())) {
                    boolean bl = needsCoercion = !royaleDocEmitter.getLocalSettingAsBoolean(JSRoyaleEmitterTokens.SUPPRESS_COMPLEX_IMPLICIT_COERCION, (Boolean)false);
                }
                if (needsCoercion) {
                    String definitionName = definition.getQualifiedName();
                    if (NativeUtils.isVector(definitionName)) {
                        definitionName = definition.getBaseName();
                    }
                    if (royaleDocEmitter.getLocalSettingIncludesString(JSRoyaleEmitterTokens.SUPPRESS_COMPLEX_IMPLICIT_COERCION, definitionName)) {
                        needsCoercion = false;
                    }
                }
            }
            if (needsCoercion && definition.getQualifiedName().equals("org.apache.royale.core.WrappedHTMLElement")) {
                needsCoercion = false;
            }
            if (needsCoercion && project.getBuiltinType(IASLanguageConstants.BuiltinType.XML) != null && (project.getBuiltinType(IASLanguageConstants.BuiltinType.XML).equals(definition) || project.getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST).equals(definition))) {
                needsCoercion = false;
            }
            if (needsCoercion && assignedNode instanceof IDynamicAccessNode) {
                ITypeDefinition leftDef;
                IDynamicAccessNode dynamicAccess = (IDynamicAccessNode)assignedNode;
                ITypeDefinition dynamicAccessIndexDef = dynamicAccess.getRightOperandNode().resolveType(project);
                if (project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER).equals(dynamicAccessIndexDef) && (leftDef = dynamicAccess.getLeftOperandNode().resolveType(project)) != null) {
                    IMetaTag[] metas;
                    for (IMetaTag meta : metas = leftDef.getAllMetaTags()) {
                        IMetaTagAttribute[] attrs;
                        if (!meta.getTagName().equals("ArrayElementType")) continue;
                        for (IMetaTagAttribute attr : attrs = meta.getAllAttributes()) {
                            String t = attr.getValue();
                            if (!t.equals(definition.getQualifiedName())) continue;
                            needsCoercion = false;
                        }
                    }
                }
            }
            if (needsCoercion && project.getBuiltinType(IASLanguageConstants.BuiltinType.STRING).equals(definition)) {
                if (docEmitter instanceof JSRoyaleDocEmitter) {
                    royaleDocEmitter = (JSRoyaleDocEmitter)docEmitter;
                    needsCoercion = royaleDocEmitter.emitStringConversions;
                }
                if (needsCoercion && assignedNode instanceof FunctionCallNode && ((FunctionCallNode)assignedNode).getNameNode() instanceof MemberAccessExpressionNode && ((MemberAccessExpressionNode)((FunctionCallNode)assignedNode).getNameNode()).getRightOperandNode() instanceof IdentifierNode && ((IdentifierNode)((MemberAccessExpressionNode)((FunctionCallNode)assignedNode).getNameNode()).getRightOperandNode()).getName().equals("toString")) {
                    needsCoercion = false;
                }
            }
            if (needsCoercion) {
                coercionStart = "/* implicit cast */ " + JSRoyaleEmitterTokens.LANGUAGE_QNAME.getToken() + ASEmitterTokens.MEMBER_ACCESS.getToken() + ASEmitterTokens.AS.getToken() + ASEmitterTokens.PAREN_OPEN.getToken();
                String coercionTypeString = this.formatQualifiedName(definition.getQualifiedName());
                if (NativeUtils.isSyntheticJSType(coercionTypeString)) {
                    String synthethicType;
                    String synthCall;
                    if (NativeUtils.isVector(coercionTypeString)) {
                        synthCall = JSRoyaleEmitterTokens.SYNTH_VECTOR.getToken();
                        synthethicType = this.formatQualifiedName(coercionTypeString.substring(8, coercionTypeString.length() - 1));
                    } else {
                        synthCall = JSRoyaleEmitterTokens.SYNTH_TYPE.getToken();
                        synthethicType = coercionTypeString;
                    }
                    coercionTypeString = synthCall + ASEmitterTokens.PAREN_OPEN.getToken() + ASEmitterTokens.SINGLE_QUOTE.getToken() + synthethicType + ASEmitterTokens.SINGLE_QUOTE.getToken() + ASEmitterTokens.PAREN_CLOSE.getToken();
                }
                coercionEnd = ASEmitterTokens.COMMA.getToken() + ASEmitterTokens.SPACE.getToken() + coercionTypeString + ASEmitterTokens.COMMA.getToken() + ASEmitterTokens.SPACE.getToken() + ASEmitterTokens.TRUE.getToken() + ASEmitterTokens.PAREN_CLOSE.getToken();
                if (project instanceof RoyaleJSProject) {
                    ((RoyaleJSProject)project).needLanguage = true;
                }
                this.getModel().needLanguage = true;
            }
        }
        if (coercionStart != null) {
            this.write(coercionStart);
        }
        this.emitAssignedValue(assignedNode);
        if (coercionStart != null) {
            if (coercionEnd != null) {
                this.write(coercionEnd);
            } else {
                this.write(")");
            }
        }
    }

    @Override
    public BinaryOperatorNodeBase getGeneratedTypeCheck(ExpressionNodeBase leftOperand, ExpressionNodeBase rightOperand) {
        BinaryOperatorInstanceOfNode check = new BinaryOperatorInstanceOfNode(null, leftOperand, rightOperand);
        return check;
    }
}

