/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.compiler.tree.as.IParameterNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.ITypeNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class LocalVarAndParameterNameRule
extends LinterRule {
    public static final Pattern DEFAULT_NAME_PATTERN = Pattern.compile("^[a-z][a-zA-Z0-9]*$");
    public Pattern pattern;

    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.VariableID, (node, tokenQuery, problems) -> this.checkVariableNode((IVariableNode)node, tokenQuery, problems));
        result.put(ASTNodeID.ArgumentID, (node, tokenQuery, problems) -> this.checkParameterNode((IParameterNode)node, tokenQuery, problems));
        return result;
    }

    private void checkVariableNode(IVariableNode variableNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        Matcher matcher;
        if (variableNode.isConst()) {
            return;
        }
        IScopedNode containingScope = variableNode.getContainingScope();
        if (containingScope == null) {
            return;
        }
        IASNode possibleType = containingScope.getParent();
        if (possibleType instanceof ITypeNode || possibleType instanceof IPackageNode) {
            return;
        }
        String variableName = variableNode.getName();
        Pattern thePattern = this.pattern;
        if (thePattern == null) {
            thePattern = DEFAULT_NAME_PATTERN;
        }
        if ((matcher = thePattern.matcher(variableName)).matches()) {
            return;
        }
        problems.add(new LocalVarNameLinterProblem(variableNode, thePattern));
    }

    private void checkParameterNode(IParameterNode paramNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        Matcher matcher;
        String variableName = paramNode.getName();
        Pattern thePattern = this.pattern;
        if (thePattern == null) {
            thePattern = DEFAULT_NAME_PATTERN;
        }
        if ((matcher = thePattern.matcher(variableName)).matches()) {
            return;
        }
        problems.add(new ParameterNameLinterProblem((IVariableNode)paramNode, thePattern));
    }

    public static class ParameterNameLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Parameter name '${paramName}' does not match the pattern '${pattern}'";
        public String pattern;
        public String paramName;

        public ParameterNameLinterProblem(IVariableNode node, Pattern pattern) {
            super((ISourceLocation)node.getNameExpressionNode());
            this.pattern = pattern.toString();
            this.paramName = node.getName();
        }
    }

    public static class LocalVarNameLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Variable name '${varName}' does not match the pattern '${pattern}'";
        public String pattern;
        public String varName;

        public LocalVarNameLinterProblem(IVariableNode node, Pattern pattern) {
            super((ISourceLocation)node.getNameExpressionNode());
            this.pattern = pattern.toString();
            this.varName = node.getName();
        }
    }
}

