/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

class ConstCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType CONST_REASSIGNED_VALUE_ERROR = DiagnosticType.warning("JSC_CONSTANT_REASSIGNED_VALUE_ERROR", "constant {0} assigned a value more than once.\nOriginal definition at {1}");
    private final AbstractCompiler compiler;
    private final Set<Var> initializedConstants;

    public ConstCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.initializedConstants = new HashSet<Var>();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, this, externs, root);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case NAME: {
                if (parent == null || !NodeUtil.isNameDeclaration(parent)) break;
                String name = n.getString();
                Var var = (Var)t.getScope().getVar(name);
                if (!ConstCheck.isConstant(var)) break;
                if (n.isFromExterns()) {
                    this.initializedConstants.add(var);
                    break;
                }
                if (!n.hasChildren() || this.initializedConstants.add(var)) break;
                this.reportError(t, n, var, name);
                break;
            }
            case ASSIGN: 
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_ADD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_EXPONENT: {
                Node lhs = n.getFirstChild();
                if (!lhs.isName()) break;
                String name = lhs.getString();
                Var var = (Var)t.getScope().getVar(name);
                if (!var.isConst() && (!ConstCheck.isConstant(var) || this.initializedConstants.add(var))) break;
                this.reportError(t, n, var, name);
                break;
            }
            case INC: 
            case DEC: {
                Node lhs = n.getFirstChild();
                if (!lhs.isName()) break;
                String name = lhs.getString();
                Var var = (Var)t.getScope().getVar(name);
                if (!var.isConst() && !ConstCheck.isConstant(var)) break;
                this.reportError(t, n, var, name);
                break;
            }
        }
    }

    private static boolean isConstant(Var var) {
        return var != null && var.isInferredConst();
    }

    void reportError(NodeTraversal t, Node n, Var var, String name) {
        JSDocInfo info = NodeUtil.getBestJSDocInfo(n);
        if (info == null || !info.getSuppressions().contains("const")) {
            Node declNode = var.getNode();
            String declaredPosition = declNode.getSourceFileName() + ":" + declNode.getLineno();
            this.compiler.report(t.makeError(n, CONST_REASSIGNED_VALUE_ERROR, name, declaredPosition));
        }
    }
}

