/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea;

import com.alipay.sofa.jraft.rhea.metrics.KVMetrics;
import com.alipay.sofa.jraft.util.FileOutputSignalHandler;
import com.alipay.sofa.jraft.util.MetricReporter;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RheaKVMetricsSignalHandler
extends FileOutputSignalHandler {
    private static Logger LOG = LoggerFactory.getLogger(RheaKVMetricsSignalHandler.class);
    private static final String DIR = SystemPropertyUtil.get((String)"rheakv.signal.metrics.dir", (String)"");
    private static final String BASE_NAME = "rheakv_metrics.log";

    public void handle(String signalName) {
        try {
            File file = this.getOutputFile(DIR, BASE_NAME);
            LOG.info("Printing rheakv metrics with signal: {} to file: {}.", (Object)signalName, (Object)file);
            try (PrintStream out = new PrintStream(new FileOutputStream(file, true));){
                MetricReporter reporter = MetricReporter.forRegistry((MetricRegistry)KVMetrics.metricRegistry()).outputTo(out).prefixedWith("-- rheakv").build();
                reporter.report();
            }
        }
        catch (IOException e) {
            LOG.error("Fail to print rheakv metrics.", (Throwable)e);
        }
    }
}

