/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.connect.sink;

import io.openmessaging.KeyValue;
import io.openmessaging.connector.api.component.task.sink.SinkTask;
import io.openmessaging.connector.api.data.ConnectRecord;
import io.openmessaging.connector.api.errors.ConnectException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;

public class FileSinkTask
extends SinkTask {
    private String fileName = System.getProperty("user.home") + "/demo";
    private PrintStream outputStream;

    @Override
    public void put(List<ConnectRecord> sinkRecords) throws ConnectException {
        if (sinkRecords == null || sinkRecords.isEmpty()) {
            return;
        }
        for (ConnectRecord connectRecord : sinkRecords) {
            try {
                this.outputStream.println(connectRecord.getData());
            }
            catch (Throwable e) {
                throw new ConnectException("Write record to file failed.", e);
            }
        }
        this.outputStream.flush();
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void validate(KeyValue config) {
    }

    @Override
    public void init(KeyValue config) {
        String inputFileName = config.getString("fileName");
        if (inputFileName != null) {
            this.fileName = inputFileName;
        }
        try {
            this.outputStream = new PrintStream(Files.newOutputStream(Paths.get(this.fileName, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.APPEND), false, StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new ConnectException("Create outputStream: " + this.fileName + " for FileSinkTask failed", e);
        }
    }

    @Override
    public void stop() {
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

