/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.SelectMappedBufferResult;

public class GetMessageResultExt
extends GetMessageResult {
    private final List<Long> tagCodeList = new ArrayList<Long>();

    public void addMessageExt(SelectMappedBufferResult bufferResult, long queueOffset, long tagCode) {
        super.addMessage(bufferResult, queueOffset);
        this.tagCodeList.add(tagCode);
    }

    public List<Long> getTagCodeList() {
        return this.tagCodeList;
    }

    public GetMessageResult doFilterMessage(MessageFilter messageFilter) {
        if (GetMessageStatus.FOUND != super.getStatus() || messageFilter == null) {
            return this;
        }
        GetMessageResult result = new GetMessageResult();
        result.setStatus(GetMessageStatus.FOUND);
        result.setMinOffset(this.getMinOffset());
        result.setMaxOffset(this.getMaxOffset());
        result.setNextBeginOffset(this.getNextBeginOffset());
        for (int i = 0; i < this.getMessageMapedList().size(); ++i) {
            SelectMappedBufferResult bufferResult;
            if (!messageFilter.isMatchedByConsumeQueue(this.tagCodeList.get(i), null) || !messageFilter.isMatchedByCommitLog((bufferResult = (SelectMappedBufferResult)this.getMessageMapedList().get(i)).getByteBuffer().slice(), null)) continue;
            long offset = (Long)this.getMessageQueueOffset().get(i);
            result.addMessage(new SelectMappedBufferResult(bufferResult.getStartOffset(), bufferResult.getByteBuffer().asReadOnlyBuffer(), bufferResult.getSize(), null), offset);
        }
        if (result.getBufferTotalSize() == 0) {
            result.setStatus(GetMessageStatus.NO_MATCHED_MESSAGE);
        }
        return result;
    }
}

